/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.ArrayDeque;
import java.util.Deque;
import spoon.reflect.code.CtExpression;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtType;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.TypeContext;

public class PrintingContext {
    private long NO_TYPE_DECL = 1L;
    private long IGNORE_GENERICS = 2L;
    private long SKIP_ARRAY = 4L;
    private long IGNORE_STATIC_ACCESS = 8L;
    private long IGNORE_ENCLOSING_CLASS = 16L;
    private long state;
    Deque<TypeContext> currentThis = new ArrayDeque<TypeContext>();
    Deque<CtElement> elementStack = new ArrayDeque<CtElement>();
    Deque<CtExpression<?>> parenthesedExpression = new ArrayDeque();
    CtType<?> currentTopLevel;

    public boolean noTypeDecl() {
        return (this.state & this.NO_TYPE_DECL) != 0L;
    }

    public boolean ignoreGenerics() {
        return (this.state & this.IGNORE_GENERICS) != 0L;
    }

    public boolean skipArray() {
        return (this.state & this.SKIP_ARRAY) != 0L;
    }

    public boolean ignoreStaticAccess() {
        return (this.state & this.IGNORE_STATIC_ACCESS) != 0L;
    }

    public boolean ignoreEnclosingClass() {
        return (this.state & this.IGNORE_ENCLOSING_CLASS) != 0L;
    }

    public Writable modify() {
        return new Writable();
    }

    public CtTypeReference<?> getCurrentTypeReference() {
        if (this.currentTopLevel != null) {
            TypeContext tc = this.getCurrentTypeContext();
            if (tc != null) {
                return tc.typeRef;
            }
            return this.currentTopLevel.getReference();
        }
        return null;
    }

    private TypeContext getCurrentTypeContext() {
        if (this.currentThis != null && this.currentThis.size() > 0) {
            TypeContext tc = this.currentThis.peek();
            return tc;
        }
        return null;
    }

    public void pushCurrentThis(CtType<?> type) {
        this.currentThis.push(new TypeContext(type));
    }

    public void popCurrentThis() {
        this.currentThis.pop();
    }

    public String toString() {
        return "context.ignoreGenerics: " + this.ignoreGenerics() + "\n";
    }

    public boolean isInCurrentScope(CtTypeReference<?> typeRef) {
        CtTypeReference<?> currentTypeRef = this.getCurrentTypeReference();
        return currentTypeRef != null && typeRef.equals(currentTypeRef);
    }

    public class Writable
    implements AutoCloseable {
        private long oldState;

        protected Writable() {
            this.oldState = PrintingContext.this.state;
        }

        @Override
        public void close() {
            PrintingContext.this.state = this.oldState;
        }

        public <T extends Writable> T noTypeDecl(boolean v) {
            this.setState(PrintingContext.this.NO_TYPE_DECL, v);
            return (T)this;
        }

        public <T extends Writable> T ignoreGenerics(boolean v) {
            this.setState(PrintingContext.this.IGNORE_GENERICS, v);
            return (T)this;
        }

        public <T extends Writable> T skipArray(boolean v) {
            this.setState(PrintingContext.this.SKIP_ARRAY, v);
            return (T)this;
        }

        public <T extends Writable> T ignoreStaticAccess(boolean v) {
            this.setState(PrintingContext.this.IGNORE_STATIC_ACCESS, v);
            return (T)this;
        }

        public <T extends Writable> T ignoreEnclosingClass(boolean v) {
            this.setState(PrintingContext.this.IGNORE_ENCLOSING_CLASS, v);
            return (T)this;
        }

        private void setState(long mask, boolean v) {
            PrintingContext.this.state = v ? PrintingContext.this.state | mask : PrintingContext.this.state & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }
}

