/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import spoon.reflect.code.CtBlock;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtVariable;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.AccessibleVariablesFinder;
import spoon.reflect.visitor.ImportScanner;
import spoon.reflect.visitor.ImportScannerImpl;

public class MinimalImportScanner
extends ImportScannerImpl
implements ImportScanner {
    private Set<String> fieldAndMethodsNames = new HashSet<String>();

    private CtClass getParentClass(CtReference ref) {
        CtElement parent;
        for (parent = ref.getParent(); parent != null && !(parent instanceof CtClass); parent = parent.getParent()) {
        }
        if (parent == null) {
            return null;
        }
        return (CtClass)parent;
    }

    private Set<String> lookForLocalVariables(CtElement parent) {
        HashSet<String> result = new HashSet<String>();
        while (parent != null && !(parent instanceof CtBlock)) {
            if (parent instanceof CtClass) {
                return result;
            }
            parent = parent.getParent();
        }
        if (parent != null) {
            CtBlock block = (CtBlock)parent;
            boolean innerClass = false;
            while (parent != null && !(parent instanceof CtClass)) {
                parent = parent.getParent();
            }
            if (parent != null && !(parent.getParent() instanceof CtPackage)) {
                while (parent != null && !(parent instanceof CtBlock)) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    block = (CtBlock)parent;
                }
            }
            AccessibleVariablesFinder avf = new AccessibleVariablesFinder(block);
            List<CtVariable> variables = avf.find();
            for (CtVariable variable : variables) {
                result.add(variable.getSimpleName());
            }
        }
        return result;
    }

    private boolean shouldTypeBeImported(CtReference ref) {
        if (ref.equals(this.targetType)) {
            return true;
        }
        try {
            CtElement parent = ref instanceof CtTypeReference ? ref.getParent() : ref;
            Set<Object> localVariablesOfBlock = new HashSet();
            if (parent instanceof CtField) {
                this.fieldAndMethodsNames.add(((CtField)parent).getSimpleName());
            } else if (parent instanceof CtMethod) {
                this.fieldAndMethodsNames.add(((CtMethod)parent).getSimpleName());
            } else {
                localVariablesOfBlock = this.lookForLocalVariables(parent);
            }
            while (!(parent instanceof CtPackage)) {
                if (parent instanceof CtFieldReference || parent instanceof CtExecutableReference) {
                    CtTypeReference<?> typeReference;
                    CtElement parentType = parent;
                    LinkedList<String> qualifiedNameTokens = new LinkedList<String>();
                    if (parentType != parent) {
                        qualifiedNameTokens.add(parentType.getSimpleName());
                    }
                    if ((typeReference = parent instanceof CtFieldReference ? ((CtFieldReference)parent).getDeclaringType() : ((CtExecutableReference)parent).getDeclaringType()) != null) {
                        qualifiedNameTokens.add(typeReference.getSimpleName());
                        if (typeReference.getPackage() != null) {
                            CtPackage ctPackage = typeReference.getPackage().getDeclaration();
                            while (ctPackage != null) {
                                qualifiedNameTokens.add(ctPackage.getSimpleName());
                                CtElement packParent = ctPackage.getParent();
                                if (packParent.getParent() != null && !((CtPackage)packParent).getSimpleName().equals("unnamed package")) {
                                    ctPackage = (CtPackage)packParent;
                                    continue;
                                }
                                ctPackage = null;
                            }
                        }
                    }
                    if (!qualifiedNameTokens.isEmpty() && (this.fieldAndMethodsNames.contains(qualifiedNameTokens.getLast()) || localVariablesOfBlock.contains(qualifiedNameTokens.getLast()))) {
                        return true;
                    }
                }
                parent = parent.getParent();
            }
        }
        catch (ParentNotInitializedException e) {
            return false;
        }
        return false;
    }

    @Override
    protected boolean addClassImport(CtTypeReference<?> ref) {
        boolean shouldTypeBeImported = this.shouldTypeBeImported(ref);
        if (shouldTypeBeImported) {
            return super.addClassImport(ref);
        }
        return false;
    }

    @Override
    protected boolean addFieldImport(CtFieldReference ref) {
        boolean shouldTypeBeImported = this.shouldTypeBeImported(ref);
        if (shouldTypeBeImported) {
            if (this.fieldImports.containsKey(ref.getSimpleName())) {
                return this.isImportedInFieldImports(ref);
            }
            this.fieldImports.put(ref.getSimpleName(), ref);
            return true;
        }
        return false;
    }

    @Override
    protected boolean addMethodImport(CtExecutableReference ref) {
        boolean shouldTypeBeImported = this.shouldTypeBeImported(ref);
        if (shouldTypeBeImported) {
            if (this.methodImports.containsKey(ref.getSimpleName())) {
                return this.isImportedInMethodImports(ref);
            }
            this.methodImports.put(ref.getSimpleName(), ref);
            if (ref.getDeclaringType() != null && ref.getDeclaringType().getPackage() != null && ref.getDeclaringType().getPackage().equals(this.targetType.getPackage())) {
                this.addClassImport(ref.getDeclaringType());
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isImportedInClassImports(CtTypeReference<?> ref) {
        CtTypeReference exist;
        return !ref.isImplicit() && this.classImports.containsKey(ref.getSimpleName()) && (exist = (CtTypeReference)this.classImports.get(ref.getSimpleName())).getQualifiedName().equals(ref.getQualifiedName());
    }
}

