/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.visitor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import spoon.reflect.code.CtCatchVariable;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtFieldRead;
import spoon.reflect.code.CtFieldWrite;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.declaration.CtAnnotationType;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtEnum;
import spoon.reflect.declaration.CtExecutable;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeMember;
import spoon.reflect.declaration.ParentNotInitializedException;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.reference.CtPackageReference;
import spoon.reflect.reference.CtReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.ImportScanner;
import spoon.support.SpoonClassNotFoundException;

public class ImportScannerImpl
extends CtScanner
implements ImportScanner {
    private static final Collection<String> namesPresentInJavaLang8 = Collections.singletonList("FunctionalInterface");
    private static final Collection<String> namesPresentInJavaLang9 = Arrays.asList("ProcessHandle", "StackWalker", "StackFramePermission");
    protected Map<String, CtTypeReference<?>> classImports = new TreeMap();
    protected Map<String, CtFieldReference<?>> fieldImports = new TreeMap();
    protected Map<String, CtExecutableReference<?>> methodImports = new TreeMap();
    protected CtTypeReference<?> targetType;
    private Map<String, Boolean> namesPresentInJavaLang = new HashMap<String, Boolean>();

    @Override
    public <T> void visitCtFieldRead(CtFieldRead<T> fieldRead) {
        this.enter(fieldRead);
        this.scan(fieldRead.getVariable());
        this.scan(fieldRead.getAnnotations());
        this.scan(fieldRead.getTypeCasts());
        this.scan(fieldRead.getVariable());
        this.scan((CtElement)fieldRead.getTarget());
        this.exit(fieldRead);
    }

    @Override
    public <T> void visitCtFieldWrite(CtFieldWrite<T> fieldWrite) {
        this.enter(fieldWrite);
        this.scan(fieldWrite.getVariable());
        this.scan(fieldWrite.getAnnotations());
        this.scan(fieldWrite.getTypeCasts());
        this.scan(fieldWrite.getVariable());
        this.scan((CtElement)fieldWrite.getTarget());
        this.exit(fieldWrite);
    }

    @Override
    public <T> void visitCtFieldReference(CtFieldReference<T> reference) {
        this.enter(reference);
        if (reference.isStatic()) {
            if (!this.addFieldImport(reference)) {
                this.scan(reference.getDeclaringType());
            }
        } else {
            this.scan(reference.getDeclaringType());
        }
        this.exit(reference);
    }

    @Override
    public <T> void visitCtExecutableReference(CtExecutableReference<T> reference) {
        this.enter(reference);
        if (reference.isStatic()) {
            this.addMethodImport(reference);
        } else if (reference.isConstructor()) {
            this.scan(reference.getDeclaringType());
        }
        this.scan(reference.getActualTypeArguments());
        this.exit(reference);
    }

    @Override
    public <T> void visitCtInvocation(CtInvocation<T> invocation) {
        this.enter(invocation);
        this.scan(invocation.getAnnotations());
        this.scan(invocation.getTypeCasts());
        this.scan((CtElement)invocation.getTarget());
        this.scan(invocation.getExecutable());
        this.scan(invocation.getArguments());
        this.exit(invocation);
    }

    @Override
    public <T> void visitCtTypeReference(CtTypeReference<T> reference) {
        if (!(reference instanceof CtArrayTypeReference)) {
            if (reference.getDeclaringType() == null) {
                this.addClassImport(reference);
            } else {
                this.addClassImport(reference.getAccessType());
            }
        }
        super.visitCtTypeReference(reference);
    }

    @Override
    public void scan(CtElement element) {
        if (element != null && !element.isImplicit()) {
            element.accept(this);
        }
    }

    @Override
    public <A extends Annotation> void visitCtAnnotationType(CtAnnotationType<A> annotationType) {
        this.addClassImport(annotationType.getReference());
        super.visitCtAnnotationType(annotationType);
    }

    @Override
    public <T extends Enum<?>> void visitCtEnum(CtEnum<T> ctEnum) {
        this.addClassImport(ctEnum.getReference());
        super.visitCtEnum(ctEnum);
    }

    @Override
    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.addClassImport(intrface.getReference());
        for (CtTypeMember t : intrface.getTypeMembers()) {
            if (!(t instanceof CtType)) continue;
            this.addClassImport(((CtType)t).getReference());
        }
        super.visitCtInterface(intrface);
    }

    @Override
    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.addClassImport(ctClass.getReference());
        for (CtTypeMember t : ctClass.getTypeMembers()) {
            if (!(t instanceof CtType)) continue;
            this.addClassImport(((CtType)t).getReference());
        }
        super.visitCtClass(ctClass);
    }

    @Override
    public <T> void visitCtCatchVariable(CtCatchVariable<T> catchVariable) {
        for (CtTypeReference<?> type : catchVariable.getMultiTypes()) {
            this.addClassImport(type);
        }
        super.visitCtCatchVariable(catchVariable);
    }

    @Override
    public Collection<CtReference> computeAllImports(CtType<?> simpleType) {
        this.classImports.clear();
        this.fieldImports.clear();
        this.methodImports.clear();
        this.targetType = simpleType.getReference().getTopLevelType();
        this.addClassImport(simpleType.getReference());
        this.scan(simpleType);
        ArrayList<CtReference> listallImports = new ArrayList<CtReference>();
        listallImports.addAll(this.classImports.values());
        listallImports.addAll(this.fieldImports.values());
        listallImports.addAll(this.methodImports.values());
        return listallImports;
    }

    @Override
    public Collection<CtTypeReference<?>> computeImports(CtType<?> simpleType) {
        this.classImports.clear();
        this.fieldImports.clear();
        this.methodImports.clear();
        this.targetType = simpleType.getReference().getTopLevelType();
        this.addClassImport(simpleType.getReference());
        this.scan(simpleType);
        return this.classImports.values();
    }

    @Override
    public void computeImports(CtElement element) {
        this.classImports.clear();
        this.fieldImports.clear();
        this.methodImports.clear();
        CtType type = element.getParent(CtType.class);
        this.targetType = type == null ? null : type.getReference().getTopLevelType();
        this.scan(element);
    }

    @Override
    public boolean isImported(CtReference ref) {
        if (ref instanceof CtFieldReference) {
            return this.isImportedInFieldImports((CtFieldReference)ref);
        }
        if (ref instanceof CtExecutableReference) {
            return this.isImportedInMethodImports((CtExecutableReference)ref);
        }
        if (ref instanceof CtTypeReference) {
            return this.isImportedInClassImports((CtTypeReference)ref);
        }
        return false;
    }

    protected boolean addClassImport(CtTypeReference<?> ref) {
        if (this.classImports.containsKey(ref.getSimpleName())) {
            return this.isImportedInClassImports(ref);
        }
        if (ref.getPackage() == null || ref.getPackage().isUnnamedPackage()) {
            return false;
        }
        if (ref.getPackage().getSimpleName().equals("java.lang") && this.classNamePresentInJavaLang(ref)) {
            return false;
        }
        if (this.targetType != null && !this.targetType.canAccess(ref)) {
            return false;
        }
        if (this.targetType != null) {
            try {
                CtElement parent = ref.getParent();
                if (parent != null && (parent = parent.getParent()) != null && (parent instanceof CtFieldAccess || parent instanceof CtExecutable || parent instanceof CtInvocation)) {
                    CtReference reference;
                    CtTypeReference<?> declaringType;
                    CtPackageReference pack = this.targetType.getPackage();
                    if (parent instanceof CtFieldAccess) {
                        CtFieldAccess field = (CtFieldAccess)parent;
                        CtFieldReference localReference = field.getVariable();
                        declaringType = localReference.getDeclaringType();
                        reference = localReference;
                    } else if (parent instanceof CtExecutable) {
                        CtExecutable exec = (CtExecutable)parent;
                        CtExecutableReference localReference = exec.getReference();
                        declaringType = localReference.getDeclaringType();
                        reference = localReference;
                    } else if (parent instanceof CtInvocation) {
                        CtInvocation invo = (CtInvocation)parent;
                        CtExecutableReference localReference = invo.getExecutable();
                        declaringType = localReference.getDeclaringType();
                        reference = localReference;
                    } else {
                        declaringType = null;
                        reference = null;
                    }
                    if (reference != null && this.isImported(reference) && declaringType != null && declaringType.getPackage() != null && !declaringType.getPackage().isUnnamedPackage() && !declaringType.getPackage().getSimpleName().equals("java.lang") && declaringType.getPackage().getSimpleName().equals(pack.getSimpleName())) {
                        this.classImports.put(ref.getSimpleName(), ref);
                        return true;
                    }
                }
            }
            catch (ParentNotInitializedException parent) {
                // empty catch block
            }
            CtPackageReference pack = this.targetType.getPackage();
            if (ref.getPackage() != null && !ref.getPackage().isUnnamedPackage() && !ref.getPackage().getSimpleName().equals("java.lang") && ref.getPackage().getSimpleName().equals(pack.getSimpleName())) {
                return false;
            }
        }
        this.classImports.put(ref.getSimpleName(), ref);
        return true;
    }

    protected boolean isImportedInClassImports(CtTypeReference<?> ref) {
        CtTypeReference<?> exist;
        if (this.targetType != null) {
            CtPackageReference pack = this.targetType.getPackage();
            if (ref.getPackage() != null && !ref.getPackage().isUnnamedPackage() && !ref.getPackage().getSimpleName().equals("java.lang") && ref.getPackage().getSimpleName().equals(pack.getSimpleName())) {
                return true;
            }
        }
        if (ref.equals(this.targetType)) {
            return true;
        }
        return !ref.isImplicit() && this.classImports.containsKey(ref.getSimpleName()) && (exist = this.classImports.get(ref.getSimpleName())).getQualifiedName().equals(ref.getQualifiedName());
    }

    private boolean declaringTypeIsLocalOrImported(CtTypeReference declaringType) {
        if (declaringType != null) {
            if (this.isImportedInClassImports(declaringType)) {
                return true;
            }
            while (declaringType != null) {
                if (declaringType.equals(this.targetType)) {
                    return true;
                }
                declaringType = declaringType.getDeclaringType();
            }
        }
        return false;
    }

    protected boolean addMethodImport(CtExecutableReference ref) {
        if (this.methodImports.containsKey(ref.getSimpleName())) {
            return this.isImportedInMethodImports(ref);
        }
        if (this.declaringTypeIsLocalOrImported(ref.getDeclaringType())) {
            return false;
        }
        this.methodImports.put(ref.getSimpleName(), ref);
        if (ref.getDeclaringType() != null && ref.getDeclaringType().getPackage() != null && ref.getDeclaringType().getPackage().equals(this.targetType.getPackage())) {
            this.addClassImport(ref.getDeclaringType());
        }
        return true;
    }

    protected boolean isImportedInMethodImports(CtExecutableReference<?> ref) {
        CtExecutableReference<?> exist;
        return !ref.isImplicit() && this.methodImports.containsKey(ref.getSimpleName()) && (exist = this.methodImports.get(ref.getSimpleName())).getSignature().equals(ref.getSignature());
    }

    protected boolean addFieldImport(CtFieldReference ref) {
        if (this.fieldImports.containsKey(ref.getSimpleName())) {
            return this.isImportedInFieldImports(ref);
        }
        if (this.declaringTypeIsLocalOrImported(ref.getDeclaringType())) {
            return false;
        }
        this.fieldImports.put(ref.getSimpleName(), ref);
        return true;
    }

    protected boolean isImportedInFieldImports(CtFieldReference<?> ref) {
        if (!ref.isImplicit() && this.fieldImports.containsKey(ref.getSimpleName())) {
            CtFieldReference<?> exist = this.fieldImports.get(ref.getSimpleName());
            try {
                if (exist.getFieldDeclaration() != null && exist.getFieldDeclaration().equals(ref.getFieldDeclaration())) {
                    return true;
                }
            }
            catch (SpoonClassNotFoundException notfound) {
                return false;
            }
        }
        return false;
    }

    protected boolean classNamePresentInJavaLang(CtTypeReference<?> ref) {
        Boolean presentInJavaLang = this.namesPresentInJavaLang.get(ref.getSimpleName());
        if (presentInJavaLang == null) {
            if (namesPresentInJavaLang8.contains(ref.getSimpleName()) || namesPresentInJavaLang9.contains(ref.getSimpleName())) {
                presentInJavaLang = true;
            } else {
                try {
                    Class.forName("java.lang." + ref.getSimpleName());
                    presentInJavaLang = true;
                }
                catch (ClassNotFoundException e) {
                    presentInJavaLang = false;
                }
            }
            this.namesPresentInJavaLang.put(ref.getSimpleName(), presentInJavaLang);
        }
        return presentInJavaLang;
    }
}

