/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.path.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtNamedElement;
import spoon.reflect.path.impl.AbstractPathElement;
import spoon.reflect.visitor.CtInheritanceScanner;

public class CtNamedPathElement
extends AbstractPathElement<CtElement, CtElement> {
    public static final String STRING = ".";
    public static final String WILDCARD = "*";
    public static final String RECURSIVE_WILCARD = "**";
    private final String pattern;

    public CtNamedPathElement(String pattern) {
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return STRING + this.getPattern() + this.getParamString();
    }

    @Override
    public Collection<CtElement> getElements(Collection<CtElement> roots) {
        ArrayList<CtElement> results = new ArrayList<CtElement>();
        for (CtElement element : roots) {
            results.addAll(this.scanElements(this.getChilds(element)));
        }
        return results;
    }

    public Collection<CtElement> scanElements(Collection<? extends CtElement> roots) {
        NameScanner nameScanner = new NameScanner();
        if (RECURSIVE_WILCARD.equals(this.pattern)) {
            nameScanner.recurse(roots);
        } else {
            nameScanner.scan(roots);
        }
        return nameScanner.getResults();
    }

    private class NameScanner
    extends CtInheritanceScanner {
        private Collection<CtElement> results = new LinkedList<CtElement>();

        NameScanner() {
        }

        @Override
        public void scanCtElement(CtElement e) {
            if (CtNamedPathElement.WILDCARD.equals(CtNamedPathElement.this.pattern) || CtNamedPathElement.RECURSIVE_WILCARD.equals(CtNamedPathElement.this.pattern)) {
                this.results.add(e);
            } else if (e instanceof CtNamedElement && ((CtNamedElement)e).getSimpleName().matches(CtNamedPathElement.this.pattern)) {
                this.results.add(e);
            }
        }

        private void recurse(Collection<? extends CtElement> elements) {
            this.scan(elements);
            for (CtElement ctElement : elements) {
                this.recurse(CtNamedPathElement.this.getChilds(ctElement));
            }
        }

        public Collection<CtElement> getResults() {
            return this.results;
        }
    }
}

