/*
 * Decompiled with CFR 0.152.
 */
package spoon.reflect.factory;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.reflect.code.CtNewClass;
import spoon.reflect.declaration.CtAnnotation;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.factory.Factory;
import spoon.reflect.factory.FactoryImpl;
import spoon.reflect.factory.SubFactory;
import spoon.reflect.reference.CtArrayTypeReference;
import spoon.reflect.reference.CtIntersectionTypeReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.filter.TypeFilter;
import spoon.support.DefaultCoreFactory;
import spoon.support.SpoonClassNotFoundException;
import spoon.support.StandardEnvironment;
import spoon.support.visitor.java.JavaReflectionTreeBuilder;
import spoon.testing.utils.ModelUtils;

public class TypeFactory
extends SubFactory {
    private static final Set<String> NULL_PACKAGE_CLASSES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("void", "boolean", "byte", "short", "char", "int", "float", "long", "double", "<nulltype>")));
    public final CtTypeReference<?> NULL_TYPE = this.createReference("<nulltype>");
    public final CtTypeReference<Void> VOID = this.createReference(Void.class);
    public final CtTypeReference<String> STRING = this.createReference(String.class);
    public final CtTypeReference<Boolean> BOOLEAN = this.createReference(Boolean.class);
    public final CtTypeReference<Byte> BYTE = this.createReference(Byte.class);
    public final CtTypeReference<Character> CHARACTER = this.createReference(Character.class);
    public final CtTypeReference<Integer> INTEGER = this.createReference(Integer.class);
    public final CtTypeReference<Long> LONG = this.createReference(Long.class);
    public final CtTypeReference<Float> FLOAT = this.createReference(Float.class);
    public final CtTypeReference<Double> DOUBLE = this.createReference(Double.class);
    public final CtTypeReference<Void> VOID_PRIMITIVE = this.createReference(Void.TYPE);
    public final CtTypeReference<Boolean> BOOLEAN_PRIMITIVE = this.createReference(Boolean.TYPE);
    public final CtTypeReference<Byte> BYTE_PRIMITIVE = this.createReference(Byte.TYPE);
    public final CtTypeReference<Character> CHARACTER_PRIMITIVE = this.createReference(Character.TYPE);
    public final CtTypeReference<Integer> INTEGER_PRIMITIVE = this.createReference(Integer.TYPE);
    public final CtTypeReference<Long> LONG_PRIMITIVE = this.createReference(Long.TYPE);
    public final CtTypeReference<Float> FLOAT_PRIMITIVE = this.createReference(Float.TYPE);
    public final CtTypeReference<Double> DOUBLE_PRIMITIVE = this.createReference(Double.TYPE);
    public final CtTypeReference<Short> SHORT = this.createReference(Short.class);
    public final CtTypeReference<Short> SHORT_PRIMITIVE = this.createReference(Short.TYPE);
    public final CtTypeReference<Date> DATE = this.createReference(Date.class);
    public final CtTypeReference<Object> OBJECT = this.createReference(Object.class);
    private final Map<Class<?>, CtType<?>> shadowCache = new HashMap();

    public CtTypeReference<?> nullType() {
        return this.NULL_TYPE.clone();
    }

    public CtTypeReference<Void> voidType() {
        return this.VOID.clone();
    }

    public CtTypeReference<Void> voidPrimitiveType() {
        return this.VOID_PRIMITIVE.clone();
    }

    public CtTypeReference<String> stringType() {
        return this.STRING.clone();
    }

    public CtTypeReference<Boolean> booleanType() {
        return this.BOOLEAN.clone();
    }

    public CtTypeReference<Boolean> booleanPrimitiveType() {
        return this.BOOLEAN_PRIMITIVE.clone();
    }

    public CtTypeReference<Byte> byteType() {
        return this.BYTE.clone();
    }

    public CtTypeReference<Byte> bytePrimitiveType() {
        return this.BYTE_PRIMITIVE.clone();
    }

    public CtTypeReference<Character> characterType() {
        return this.CHARACTER.clone();
    }

    public CtTypeReference<Character> characterPrimitiveType() {
        return this.CHARACTER_PRIMITIVE.clone();
    }

    public CtTypeReference<Integer> integerType() {
        return this.INTEGER.clone();
    }

    public CtTypeReference<Integer> integerPrimitiveType() {
        return this.INTEGER_PRIMITIVE.clone();
    }

    public CtTypeReference<Long> longType() {
        return this.LONG.clone();
    }

    public CtTypeReference<Long> longPrimitiveType() {
        return this.LONG_PRIMITIVE.clone();
    }

    public CtTypeReference<Float> floatType() {
        return this.FLOAT.clone();
    }

    public CtTypeReference<Float> floatPrimitiveType() {
        return this.FLOAT_PRIMITIVE.clone();
    }

    public CtTypeReference<Double> doubleType() {
        return this.DOUBLE.clone();
    }

    public CtTypeReference<Double> doublePrimitiveType() {
        return this.DOUBLE_PRIMITIVE.clone();
    }

    public CtTypeReference<?> shortType() {
        return this.SHORT.clone();
    }

    public CtTypeReference<?> shortPrimitiveType() {
        return this.SHORT_PRIMITIVE.clone();
    }

    public CtTypeReference<?> dateType() {
        return this.DATE.clone();
    }

    public CtTypeReference<?> objectType() {
        return this.OBJECT.clone();
    }

    public TypeFactory(Factory factory) {
        super(factory);
    }

    public TypeFactory() {
        this(new FactoryImpl(new DefaultCoreFactory(), new StandardEnvironment()));
    }

    public <T> CtArrayTypeReference<T[]> createArrayReference(CtType<T> type) {
        CtArrayTypeReference<T[]> array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(this.createReference(type));
        return array;
    }

    public <T> CtArrayTypeReference<T[]> createArrayReference(CtTypeReference<T> reference) {
        CtArrayTypeReference<T[]> array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(reference);
        return array;
    }

    public CtArrayTypeReference<?> createArrayReference(CtTypeReference<?> reference, int n) {
        CtArrayTypeReference<?> componentType = null;
        if (n == 1) {
            return this.createArrayReference(reference);
        }
        componentType = this.createArrayReference(reference, n - 1);
        CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(componentType);
        return array;
    }

    public <T> CtArrayTypeReference<T> createArrayReference(String qualifiedName) {
        CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
        array.setComponentType(this.createReference(qualifiedName));
        return array;
    }

    public <T> CtTypeReference<T> createReference(Class<T> type) {
        if (type == null) {
            return null;
        }
        if (type.isArray()) {
            CtArrayTypeReference array = this.factory.Core().createArrayTypeReference();
            array.setComponentType(this.createReference(type.getComponentType()));
            return array;
        }
        return this.createReference(type.getName());
    }

    public <T> CtTypeReference<T> createReference(CtType<T> type) {
        CtTypeReference ref = this.factory.Core().createTypeReference();
        if (type.getDeclaringType() != null) {
            ref.setDeclaringType(this.createReference(type.getDeclaringType()));
        } else if (type.getPackage() != null) {
            ref.setPackage(this.factory.Package().createReference(type.getPackage()));
        }
        ref.setSimpleName(type.getSimpleName());
        return ref;
    }

    public CtTypeParameterReference createReference(CtTypeParameter type) {
        CtTypeParameterReference ref = this.factory.Core().createTypeParameterReference();
        if (type.getSuperclass() != null) {
            ref.setBoundingType(type.getSuperclass().clone());
        }
        for (CtAnnotation<? extends Annotation> ctAnnotation : type.getAnnotations()) {
            ref.addAnnotation(ctAnnotation.clone());
        }
        ref.setSimpleName(type.getSimpleName());
        return ref;
    }

    public <T> CtTypeReference<T> createReference(String qualifiedName) {
        if (qualifiedName.endsWith("[]")) {
            return this.createArrayReference(qualifiedName.substring(0, qualifiedName.length() - 2));
        }
        CtTypeReference ref = this.factory.Core().createTypeReference();
        if (this.hasInnerType(qualifiedName) > 0) {
            ref.setDeclaringType(this.createReference(this.getDeclaringTypeName(qualifiedName)));
        } else if (this.hasPackage(qualifiedName) > 0) {
            ref.setPackage(this.factory.Package().createReference(this.getPackageName(qualifiedName)));
        } else if (!NULL_PACKAGE_CLASSES.contains(qualifiedName)) {
            ref.setPackage(this.factory.Package().topLevel());
        }
        ref.setSimpleName(this.getSimpleName(qualifiedName));
        return ref;
    }

    public <T> CtType<T> get(final String qualifiedName) {
        int inertTypeIndex = qualifiedName.lastIndexOf("$");
        if (inertTypeIndex > 0) {
            String s = qualifiedName.substring(0, inertTypeIndex);
            CtType<T> t = this.factory.Type().get(s);
            if (t == null) {
                return null;
            }
            String className = qualifiedName.substring(inertTypeIndex + 1);
            CtTypeReference<T> reference = t.getReference();
            if (reference.isLocalType()) {
                List enclosingClasses = t.getElements(new TypeFilter<CtClass<T>>(CtClass.class){

                    @Override
                    public boolean matches(CtClass<T> element) {
                        return super.matches(element) && element.getQualifiedName().equals(qualifiedName);
                    }
                });
                if (enclosingClasses.size() == 0) {
                    return null;
                }
                return (CtType)enclosingClasses.get(0);
            }
            try {
                Integer.parseInt(className);
                List<CtNewClass> anonymousClasses = t.getElements(new TypeFilter<CtNewClass>(CtNewClass.class){

                    @Override
                    public boolean matches(CtNewClass element) {
                        return super.matches(element) && element.getAnonymousClass().getQualifiedName().equals(qualifiedName);
                    }
                });
                if (anonymousClasses.size() == 0) {
                    return null;
                }
                return anonymousClasses.get(0).getAnonymousClass();
            }
            catch (NumberFormatException e) {
                return t.getNestedType(className);
            }
        }
        int packageIndex = qualifiedName.lastIndexOf(".");
        CtPackage pack = packageIndex > 0 ? this.factory.Package().get(qualifiedName.substring(0, packageIndex)) : this.factory.Package().getRootPackage();
        if (pack == null) {
            return null;
        }
        return pack.getType(qualifiedName.substring(packageIndex + 1));
    }

    public List<CtType<?>> getAll() {
        return (List)this.factory.getModel().getAllTypes();
    }

    public List<CtType<?>> getAll(boolean includeNestedTypes) {
        if (!includeNestedTypes) {
            return this.getAll();
        }
        ArrayList types = new ArrayList();
        for (CtPackage pack : this.factory.Package().getAll()) {
            for (CtType<?> type : pack.getTypes()) {
                this.addNestedType(types, type);
            }
        }
        return types;
    }

    private void addNestedType(List<CtType<?>> list, CtType<?> t) {
        list.add(t);
        for (CtType<?> nt : t.getNestedTypes()) {
            this.addNestedType(list, nt);
        }
    }

    public <T> CtType<T> get(Class<?> cl) {
        CtType<T> aType = this.get(cl.getName());
        if (aType == null) {
            CtType<?> shadowClass = this.shadowCache.get(cl);
            if (shadowClass == null) {
                Object newShadowClass;
                try {
                    newShadowClass = new JavaReflectionTreeBuilder(ModelUtils.createFactory()).scan(cl);
                }
                catch (Throwable e) {
                    throw new SpoonClassNotFoundException("cannot create shadow class: " + cl.getName(), e);
                }
                newShadowClass.setFactory(this.factory);
                newShadowClass.accept(new CtScanner(){

                    @Override
                    public void scan(CtElement element) {
                        if (element != null) {
                            element.setFactory(TypeFactory.this.factory);
                        }
                    }
                });
                this.shadowCache.put(cl, (CtType<?>)newShadowClass);
                return newShadowClass;
            }
            return shadowClass;
        }
        return aType;
    }

    protected String getDeclaringTypeName(String qualifiedName) {
        return qualifiedName.substring(0, this.hasInnerType(qualifiedName));
    }

    public List<CtTypeReference<?>> createReferences(List<Class<?>> classes) {
        ArrayList refs = new ArrayList(classes.size());
        for (Class<?> c : classes) {
            refs.add(this.createReference(c));
        }
        return refs;
    }

    protected String getPackageName(String qualifiedName) {
        if (this.hasPackage(qualifiedName) >= 0) {
            return qualifiedName.substring(0, this.hasPackage(qualifiedName));
        }
        return "";
    }

    protected String getSimpleName(String qualifiedName) {
        if (this.hasInnerType(qualifiedName) > 0) {
            return qualifiedName.substring(this.hasInnerType(qualifiedName) + 1);
        }
        if (this.hasPackage(qualifiedName) > 0) {
            return qualifiedName.substring(this.hasPackage(qualifiedName) + 1);
        }
        return qualifiedName;
    }

    protected int hasInnerType(String qualifiedName) {
        int ret = qualifiedName.lastIndexOf("$");
        return ret;
    }

    protected int hasPackage(String qualifiedName) {
        return qualifiedName.lastIndexOf(".");
    }

    public CtTypeParameterReference createTypeParameterReference(String name) {
        CtTypeParameterReference typeParam = this.factory.Core().createTypeParameterReference();
        typeParam.setSimpleName(name);
        return typeParam;
    }

    public <T> CtIntersectionTypeReference<T> createIntersectionTypeReferenceWithBounds(List<CtTypeReference<?>> bounds) {
        CtIntersectionTypeReference intersectionRef = this.factory.Core().createIntersectionTypeReference();
        CtTypeReference firstBound = bounds.toArray(new CtTypeReference[0])[0].clone();
        intersectionRef.setSimpleName(firstBound.getSimpleName());
        intersectionRef.setDeclaringType(firstBound.getDeclaringType());
        intersectionRef.setPackage(firstBound.getPackage());
        intersectionRef.setActualTypeArguments(firstBound.getActualTypeArguments());
        intersectionRef.setBounds(bounds);
        return intersectionRef;
    }
}

