/*
 * Decompiled with CFR 0.152.
 */
package spoon.generating.replace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.SpoonException;
import spoon.generating.replace.ReplaceListListener;
import spoon.generating.replace.ReplaceListener;
import spoon.generating.replace.ReplaceMapListener;
import spoon.generating.replace.ReplaceSetListener;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.visitor.CtScanner;

class ReplacementVisitor
extends CtScanner {
    private CtElement original;
    private CtElement replace;

    public static void replace(CtElement original, CtElement replace) {
        try {
            new ReplacementVisitor(original, replace).scan(original.getParent());
        }
        catch (SpoonException spoonException) {
            // empty catch block
        }
    }

    private ReplacementVisitor(CtElement original, CtElement replace) {
        this.original = original;
        this.replace = replace;
    }

    private <K, V extends CtElement> void replaceInMapIfExist(Map<K, V> mapProtected, ReplaceMapListener listener) {
        HashMap<K, CtElement> map = new HashMap<K, CtElement>(mapProtected);
        CtElement shouldBeDeleted = null;
        Object key = null;
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() != this.original) continue;
            shouldBeDeleted = (CtElement)entry.getValue();
            key = entry.getKey();
            break;
        }
        if (shouldBeDeleted != null) {
            if (this.replace != null) {
                map.put(key, this.replace);
                this.replace.setParent(shouldBeDeleted.getParent());
            } else {
                map.remove(key);
            }
            listener.set(map);
        }
    }

    private <T extends CtElement> void replaceInSetIfExist(Set<T> setProtected, ReplaceSetListener listener) {
        HashSet<T> set = new HashSet<T>(setProtected);
        CtElement shouldBeDeleted = null;
        for (CtElement element : set) {
            if (element != this.original) continue;
            shouldBeDeleted = element;
            break;
        }
        if (shouldBeDeleted != null) {
            set.remove(shouldBeDeleted);
            if (this.replace != null) {
                set.add(this.replace);
                this.replace.setParent(shouldBeDeleted.getParent());
            }
            listener.set(set);
        }
    }

    private <T extends CtElement> void replaceInListIfExist(List<T> listProtected, ReplaceListListener listener) {
        ArrayList<T> list = new ArrayList<T>(listProtected);
        CtElement shouldBeDeleted = null;
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != this.original) continue;
            index = i;
            shouldBeDeleted = (CtElement)list.get(i);
            break;
        }
        if (shouldBeDeleted != null) {
            if (this.replace != null) {
                list.set(index, this.replace);
                this.replace.setParent(shouldBeDeleted.getParent());
            } else {
                list.remove(index);
            }
            listener.set(list);
        }
    }

    private void replaceElementIfExist(CtElement candidate, ReplaceListener listener) {
        if (candidate == this.original) {
            listener.set(this.replace);
            if (this.replace != null) {
                this.replace.setParent(candidate.getParent());
            }
        }
    }
}

