/*
 * Decompiled with CFR 0.152.
 */
package spoon.generating.replace;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import spoon.SpoonException;
import spoon.generating.ReplacementVisitorGenerator;
import spoon.reflect.code.CtAssignment;
import spoon.reflect.code.CtBlock;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtConstructorCall;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtFieldAccess;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtThisAccess;
import spoon.reflect.code.CtTypeAccess;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtConstructor;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeParameter;
import spoon.reflect.factory.Factory;
import spoon.reflect.reference.CtExecutableReference;
import spoon.reflect.reference.CtTypeParameterReference;
import spoon.reflect.reference.CtTypeReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.filter.TypeFilter;

public class ReplaceScanner
extends CtScanner {
    public static final String TARGET_REPLACE_PACKAGE = "spoon.support.visitor.replace";
    public static final String GENERATING_REPLACE_PACKAGE = "spoon.generating.replace";
    public static final String GENERATING_REPLACE_VISITOR = "spoon.generating.replace.ReplacementVisitor";
    private final Map<String, CtClass> listeners = new HashMap<String, CtClass>();
    private final CtClass<Object> target;
    private final CtExecutableReference<?> element;
    private final CtExecutableReference<?> list;
    private final CtExecutableReference<?> map;
    private final CtExecutableReference<?> set;

    public ReplaceScanner(CtClass<Object> target) {
        this.target = target;
        this.element = target.getMethodsByName("replaceElementIfExist").get(0).getReference();
        this.list = target.getMethodsByName("replaceInListIfExist").get(0).getReference();
        this.map = target.getMethodsByName("replaceInMapIfExist").get(0).getReference();
        this.set = target.getMethodsByName("replaceInSetIfExist").get(0).getReference();
    }

    @Override
    public <T> void visitCtMethod(CtMethod<T> element) {
        if (!element.getSimpleName().startsWith("visitCt")) {
            return;
        }
        Factory factory = element.getFactory();
        CtMethod<T> clone = element.clone();
        factory.Annotation().annotate(clone, Override.class);
        clone.getBody().getStatements().clear();
        for (int i = 1; i < element.getBody().getStatements().size() - 1; ++i) {
            CtInvocation inv = (CtInvocation)element.getBody().getStatement(i);
            CtInvocation getter = (CtInvocation)inv.getArguments().get(0);
            if (clone.getComments().size() == 0) {
                CtComment comment = factory.Core().createComment();
                comment.setCommentType(CtComment.CommentType.INLINE);
                comment.setContent("auto-generated, see " + ReplacementVisitorGenerator.class.getName());
                clone.addComment(comment);
            }
            Class actualClass = getter.getType().getActualClass();
            CtInvocation<?> invocation = this.createInvocation(factory, element, inv, getter, actualClass);
            clone.getBody().addStatement(invocation);
        }
        this.target.addMethod(clone);
    }

    private <T> CtInvocation<?> createInvocation(Factory factory, CtMethod<T> candidate, CtInvocation current, CtInvocation getter, Class getterTypeClass) {
        CtClass listener;
        Type type;
        CtInvocation<?> invocation;
        if (getterTypeClass.equals(Collection.class) || getterTypeClass.equals(List.class)) {
            invocation = factory.Code().createInvocation(null, this.list, current.getArguments());
            type = Type.LIST;
        } else if (getterTypeClass.equals(Map.class)) {
            invocation = factory.Code().createInvocation(null, this.map, current.getArguments());
            type = Type.MAP;
        } else if (getterTypeClass.equals(Set.class)) {
            invocation = factory.Code().createInvocation(null, this.set, current.getArguments());
            type = Type.SET;
        } else {
            invocation = factory.Code().createInvocation(null, this.element, current.getArguments());
            type = Type.ELEMENT;
        }
        String name = getter.getExecutable().getSimpleName().substring(3);
        String listenerName = getter.getExecutable().getDeclaringType().getSimpleName() + name + "ReplaceListener";
        if (this.listeners.containsKey(listenerName)) {
            listener = this.listeners.get(listenerName);
        } else {
            CtTypeReference getterType = this.getGetterType(factory, getter);
            listener = this.createListenerClass(factory, listenerName, getterType, type);
            CtMethod setter = this.getSetter(name, getter.getTarget().getType().getDeclaration());
            CtField field = this.updateField(listener, setter.getDeclaringType().getReference());
            this.updateConstructor(listener, setter.getDeclaringType().getReference());
            this.updateSetter(factory, listener.getMethodsByName("set").get(0), getterType, field, setter);
            CtComment comment = factory.Core().createComment();
            comment.setCommentType(CtComment.CommentType.INLINE);
            comment.setContent("auto-generated, see " + ReplacementVisitorGenerator.class.getName());
            listener.addComment(comment);
            this.listeners.put(listenerName, listener);
        }
        invocation.addArgument(this.getConstructorCall(listener, factory.Code().createVariableRead(candidate.getParameters().get(0).getReference(), false)));
        return invocation;
    }

    private CtTypeReference getGetterType(Factory factory, CtInvocation getter) {
        CtTypeReference type = getter.getType();
        CtTypeReference getterType = type instanceof CtTypeParameterReference ? this.getTypeFromTypeParameterReference((CtTypeParameterReference)getter.getExecutable().getDeclaration().getType()) : type.clone();
        getterType.getActualTypeArguments().clear();
        return getterType;
    }

    private CtTypeReference getTypeFromTypeParameterReference(CtTypeParameterReference ctTypeParameterRef) {
        CtMethod parentMethod = ctTypeParameterRef.getParent(CtMethod.class);
        for (CtTypeParameter formal : parentMethod.getFormalCtTypeParameters()) {
            if (!formal.getSimpleName().equals(ctTypeParameterRef.getSimpleName())) continue;
            return ((CtTypeParameterReference)((Object)formal)).getBoundingType();
        }
        CtInterface parentInterface = ctTypeParameterRef.getParent(CtInterface.class);
        for (CtTypeParameter formal : parentInterface.getFormalCtTypeParameters()) {
            if (!formal.getSimpleName().equals(ctTypeParameterRef.getSimpleName())) continue;
            return formal.getReference().getBoundingType();
        }
        throw new SpoonException("Can't get the type of the CtTypeParameterReference " + ctTypeParameterRef);
    }

    private CtClass createListenerClass(Factory factory, String listenerName, CtTypeReference getterType, Type type) {
        CtClass listener = factory.Class().get("spoon.generating.replace.CtListener").clone();
        listener.setSimpleName(listenerName);
        this.target.addNestedType(listener);
        List<CtTypeReference> references = listener.getElements(new TypeFilter<CtTypeReference>(CtTypeReference.class){

            @Override
            public boolean matches(CtTypeReference reference) {
                return "spoon.generating.replace.CtListener".equals(reference.getQualifiedName());
            }
        });
        for (CtTypeReference reference : references) {
            reference.setPackage(listener.getPackage().getReference());
        }
        CtTypeReference theInterface = factory.Class().createReference("spoon.generating.replace." + type.name);
        theInterface.addActualTypeArgument(getterType);
        HashSet interfaces = new HashSet();
        interfaces.add(theInterface);
        listener.setSuperInterfaces(interfaces);
        return listener;
    }

    private CtParameter<?> updateConstructor(CtClass listener, CtTypeReference type) {
        CtConstructor ctConstructor = listener.getConstructors().toArray(new CtConstructor[listener.getConstructors().size()])[0];
        CtAssignment assign = (CtAssignment)ctConstructor.getBody().getStatement(1);
        CtThisAccess fieldAccess = (CtThisAccess)((CtFieldAccess)assign.getAssigned()).getTarget();
        ((CtTypeAccess)fieldAccess.getTarget()).getAccessedType().setImplicit(true);
        CtParameter<?> aParameter = ctConstructor.getParameters().get(0);
        aParameter.setType(type);
        return aParameter;
    }

    private CtField updateField(CtClass listener, CtTypeReference<?> type) {
        CtField<?> field = listener.getField("element");
        field.setType(type);
        return field;
    }

    private void updateSetter(Factory factory, CtMethod<?> setListener, CtTypeReference getterType, CtField<?> field, CtMethod setter) {
        setListener.getParameters().get(0).setType(getterType);
        CtInvocation ctInvocation = factory.Code().createInvocation(factory.Code().createVariableRead(field.getReference(), false), setter.getReference(), factory.Code().createVariableRead(setListener.getParameters().get(0).getReference(), false));
        CtBlock<?> ctBlock = factory.Code().createCtBlock(ctInvocation);
        setListener.setBody(ctBlock);
    }

    private CtMethod getSetter(String name, CtType declaration) {
        Set<CtMethod<?>> allMethods = declaration.getAllMethods();
        CtMethod<?> setter = null;
        for (CtMethod<?> aMethod : allMethods) {
            if (!("set" + name).equals(aMethod.getSimpleName())) continue;
            setter = aMethod;
            break;
        }
        return setter;
    }

    private CtConstructorCall<?> getConstructorCall(CtClass listener, CtExpression argument) {
        return listener.getFactory().Code().createConstructorCall(listener.getReference(), argument);
    }

    static enum Type {
        ELEMENT("ReplaceListener"),
        LIST("ReplaceListListener"),
        SET("ReplaceSetListener"),
        MAP("ReplaceMapListener");

        String name;

        private Type(String name) {
            this.name = name;
        }
    }
}

