/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.dart.lib;

import io.apisense.crop.api.CropContext;
import io.apisense.dart.api.Token;
import io.apisense.dart.lib.EventBus;
import io.apisense.dart.lib.EventFilter;
import io.apisense.dart.lib.events.EventListenerAdded;
import io.apisense.dart.lib.events.EventListenerRemoved;
import java.util.HashSet;
import java.util.Set;

public final class Tokens<F> {
    private final Set<TokenImpl<F>> tokens = new HashSet<TokenImpl<F>>();
    private final EventBus bus;
    private final TokensListener<F> listener;

    public Tokens(EventBus bus, TokensListener<F> listener) {
        this.bus = bus;
        this.listener = listener;
    }

    public final Token register(Object handler, EventFilter<F> filter) {
        if (this.tokens.isEmpty()) {
            this.listener.init();
        }
        String topic = this.listener.computeTopic(filter);
        this.bus.publish(EventListenerAdded.build(CropContext.peek(), topic, handler, filter));
        TokenImpl<F> t = new TokenImpl<F>(this, CropContext.peek(), topic, handler, filter);
        this.tokens.add(t);
        return t;
    }

    protected final void unregister(TokenImpl<F> token) {
        this.listener.discardFilter(((TokenImpl)token).filter);
        this.bus.publish(EventListenerRemoved.build(((TokenImpl)token).cropId, ((TokenImpl)token).topic, ((TokenImpl)token).handler, ((TokenImpl)token).filter));
        this.tokens.remove(token);
        if (this.tokens.isEmpty()) {
            this.listener.release();
        }
    }

    public final void stop() {
        for (TokenImpl<F> t : this.tokens) {
            this.listener.discardFilter(((TokenImpl)t).filter);
            this.bus.publish(EventListenerRemoved.build(((TokenImpl)t).cropId, ((TokenImpl)t).topic, ((TokenImpl)t).handler, ((TokenImpl)t).filter));
        }
        this.tokens.clear();
        this.listener.release();
    }

    public static interface TokensListener<F> {
        public void init();

        public String computeTopic(EventFilter<F> var1);

        public void discardFilter(EventFilter<F> var1);

        public void release();
    }

    private static final class TokenImpl<F>
    implements Token {
        private final Tokens<F> tokens;
        private final EventFilter<F> filter;
        private final Object handler;
        private final String topic;
        private final String cropId;

        public TokenImpl(Tokens<F> tokens, String cropId, String topic, Object handler, EventFilter<F> filter) {
            this.cropId = cropId;
            this.topic = topic;
            this.tokens = tokens;
            this.handler = handler;
            this.filter = filter;
        }

        @Override
        public void cancel() {
            this.tokens.unregister(this);
        }

        @Override
        public String topic() {
            return this.topic;
        }
    }
}

