/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import spoon.reflect.code.CtComment;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtLiteral;
import spoon.reflect.cu.CompilationUnit;
import spoon.reflect.declaration.CtClass;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtField;
import spoon.reflect.declaration.CtInterface;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtPackage;
import spoon.reflect.declaration.CtParameter;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypedElement;
import spoon.reflect.declaration.ModifierKind;
import spoon.reflect.reference.CtFieldReference;
import spoon.reflect.visitor.CtScanner;
import spoon.reflect.visitor.PrettyPrinter;

final class JSONPrettyPrinter
extends CtScanner
implements PrettyPrinter {
    private String libraryName;
    private static final Map<String, String> TYPE_CONVERSION = new HashMap<String, String>();
    private static final String TYPE_DEFINITIONS = "!define";
    private static final String STING_DEFINITIONS = "_sting_definitions";
    private static final String LIB_NAME = "!name";
    private static final String TYPE = "!type";
    private static final String DOC = "!doc";
    private static final String NAME_FIELD = "NAME";
    private static final String VOID_TYPE = "void";
    private JsonObject generalJson = new JsonObject();
    private JsonObject typeDefinitionJson = new JsonObject();
    private JsonObject typeBindingJson = new JsonObject();

    JSONPrettyPrinter(String libName) {
        this.libraryName = libName;
    }

    public <T> void visitCtClass(CtClass<T> ctClass) {
        this.updateDocumentationForElement((CtType<T>)ctClass);
    }

    public <T> void visitCtInterface(CtInterface<T> intrface) {
        this.updateDocumentationForElement((CtType<T>)intrface);
    }

    private <T> void updateDocumentationForElement(CtType<T> ctType) {
        JsonObject stingDoc = new JsonObject();
        String name = this.findDartName(ctType);
        this.addDocumentationIfExists((CtElement)ctType, stingDoc);
        this.addMethodsDoc(ctType, stingDoc);
        this.addPropertiesDoc(ctType, stingDoc);
        this.setTypeBinding(name);
        this.updateTypeDefinition(name, stingDoc);
    }

    private void setTypeBinding(String name) {
        if (!this.typeDefinitionJson.has("_" + name)) {
            JsonObject typeBinding = new JsonObject();
            typeBinding.addProperty(TYPE, name);
            this.typeBindingJson.add("_" + name, (JsonElement)typeBinding);
        }
    }

    private void updateTypeDefinition(String name, JsonObject elements) {
        JsonObject docObject = new JsonObject();
        this.putAll(docObject, elements);
        if (this.typeDefinitionJson.has(name)) {
            this.putAll(docObject, this.typeDefinitionJson.getAsJsonObject(name));
        }
        this.typeDefinitionJson.add(name, (JsonElement)docObject);
    }

    private void putAll(JsonObject inJson, JsonObject values) {
        for (Map.Entry entry : values.entrySet()) {
            inJson.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    private <T> String findDartName(CtType<T> classOrInterface) {
        CtFieldReference nameField = classOrInterface.getDeclaredOrInheritedField(NAME_FIELD);
        if (nameField == null) {
            throw new RuntimeException("No \"NAME\" element found");
        }
        CtExpression defaultExpression = nameField.getDeclaration().getDefaultExpression();
        return (String)((CtLiteral)defaultExpression).getValue();
    }

    private <T> void addPropertiesDoc(CtType<T> ctType, JsonObject stingDoc) {
        List fields = ctType.getFields();
        fields.removeIf(field -> ctType instanceof CtClass && !field.getModifiers().contains(ModifierKind.PUBLIC));
        for (CtField field2 : fields) {
            JsonObject propertyDoc = new JsonObject();
            propertyDoc.addProperty(TYPE, this.findJsType((CtTypedElement)field2));
            this.addDocumentationIfExists((CtElement)field2, propertyDoc);
            stingDoc.add(field2.getSimpleName(), (JsonElement)propertyDoc);
        }
    }

    private <T> void addMethodsDoc(CtType<T> ctType, JsonObject stingDoc) {
        ArrayList<CtMethod> elements = new ArrayList();
        if (ctType instanceof CtInterface) {
            elements.addAll(ctType.getAllMethods());
        } else {
            elements = ctType.getElements(element -> element.hasModifier(ModifierKind.PUBLIC));
        }
        this.setDocForMethods(stingDoc, elements);
    }

    private void setDocForMethods(JsonObject stingDoc, Collection<CtMethod> elements) {
        for (CtMethod method : elements) {
            JsonObject methodDoc = new JsonObject();
            methodDoc.addProperty(TYPE, this.generateDocForMethod(method));
            this.addDocumentationIfExists((CtElement)method, methodDoc);
            stingDoc.add(method.getSimpleName(), (JsonElement)methodDoc);
        }
    }

    private void addDocumentationIfExists(CtElement element, JsonObject stingDoc) {
        if (this.javadocAvailable(element)) {
            String comments = "";
            for (CtComment comment : element.getComments()) {
                comments = comments + comment.getContent() + "\n";
            }
            stingDoc.addProperty(DOC, "\n" + comments + "\n");
        }
    }

    private boolean javadocAvailable(CtElement element) {
        return element.getComments() != null && !element.getComments().isEmpty();
    }

    private String generateDocForMethod(CtMethod<?> method) {
        String methodDoc = "fn(" + this.generateParametersSequence(method) + ")";
        String returnedType = method.getType().getSimpleName();
        if (!returnedType.equals(VOID_TYPE)) {
            methodDoc = methodDoc + " -> " + this.findJsType((CtTypedElement)method);
        }
        return methodDoc;
    }

    private String generateParametersSequence(CtMethod<?> method) {
        String argsSequence = "";
        List parameters = method.getParameters();
        for (CtParameter parameter : parameters) {
            argsSequence = argsSequence + parameter.getSimpleName() + ": " + this.findJsType((CtTypedElement)parameter) + ", ";
        }
        if (!parameters.isEmpty()) {
            argsSequence = argsSequence.substring(0, argsSequence.length() - 2);
        }
        return argsSequence;
    }

    private String findJsType(CtTypedElement field) {
        String key = field.getType().getSimpleName();
        return TYPE_CONVERSION.containsKey(key) ? TYPE_CONVERSION.get(key) : key;
    }

    public String getPackageDeclaration() {
        return null;
    }

    public String printPackageInfo(CtPackage pack) {
        return null;
    }

    public String getResult() {
        this.generalJson.add(TYPE_DEFINITIONS, (JsonElement)this.typeDefinitionJson);
        this.generalJson.add(STING_DEFINITIONS, (JsonElement)this.typeBindingJson);
        this.generalJson.addProperty(LIB_NAME, this.libraryName);
        return this.generalJson.toString();
    }

    public void reset() {
    }

    public void calculate(CompilationUnit sourceCompilationUnit, List<CtType<?>> types) {
        for (CtType<?> type : types) {
            this.scan((CtElement)type);
        }
    }

    public Map<Integer, Integer> getLineNumberMapping() {
        return null;
    }

    static {
        TYPE_CONVERSION.put("int", "num");
        TYPE_CONVERSION.put("long", "num");
        TYPE_CONVERSION.put("Integer", "num");
        TYPE_CONVERSION.put("Long", "num");
        TYPE_CONVERSION.put("Double", "num");
        TYPE_CONVERSION.put("Float", "num");
        TYPE_CONVERSION.put("Array", "Arr");
        TYPE_CONVERSION.put("List", "Arr");
        TYPE_CONVERSION.put("Map", "JSON");
        TYPE_CONVERSION.put("String", "str");
        TYPE_CONVERSION.put("boolean", "bool");
        TYPE_CONVERSION.put("Object", "fn(JSON)");
    }
}

