/*
 * Decompiled with CFR 0.152.
 */
package io.apisense.generation.api;

import io.apisense.generation.api.APISENSELauncher;
import io.apisense.generation.api.DocCommentProcessor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.OptionHandlerFilter;
import spoon.processing.Processor;

public final class APIGenerator {
    private static final String CLASSES_META_VAR = " STING_CLASSES";
    @Option(name="-n", aliases={"--name"}, usage="Determine the name of your generated library.", metaVar="LIB_NAME", required=true)
    private String libName = "CustomLibrary";
    @Option(name="-o", aliases={"--output"}, usage="Output file for the generated json.", metaVar="OUTPUT")
    private File out = new File("generatedLibrary.json");
    @Argument(usage="The Java files containing the classes to generate API from.", metaVar=" STING_CLASSES", required=true)
    private List<String> classesToAnalyze = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        new APIGenerator().execute(args);
    }

    public APIGenerator() {
    }

    public APIGenerator(File out, String libName, List<String> classesToAnalyze) {
        this.libName = libName;
        this.out = out;
        this.classesToAnalyze = classesToAnalyze;
    }

    private void execute(String[] args) throws IOException {
        CmdLineParser parser = new CmdLineParser((Object)this);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.printHelp(parser);
            return;
        }
        this.generateDocumentation();
    }

    public void generateDocumentation() throws IOException {
        assert (this.libName != null);
        assert (this.out != null);
        assert (this.classesToAnalyze != null);
        APISENSELauncher launcher = new APISENSELauncher(this.out, this.libName);
        for (String stingClass : this.classesToAnalyze) {
            launcher.addInputResource(stingClass);
        }
        launcher.addProcessor((Processor)new DocCommentProcessor());
        launcher.getEnvironment().setNoClasspath(true);
        launcher.getEnvironment().setCommentEnabled(true);
        launcher.run();
    }

    private void printHelp(CmdLineParser parser) {
        parser.printUsage((OutputStream)System.err);
        System.err.println();
        System.err.println("\tExample: java -jar sting-api-generator.jar" + parser.printExample(OptionHandlerFilter.REQUIRED) + CLASSES_META_VAR);
    }
}

