/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import io.apiman.manager.api.beans.apis.ApiDefinitionType;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.exceptions.StorageException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SwaggerWsdlHelper {
    private static final String BASE_PATH = "basePath";
    private static final String HOST = "host";
    private static final String LOCATION = "location";
    private static final String SOAP_ADDRESS = "address";
    private static final String[] SOAP_NAMESPACES = new String[]{"http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/"};
    private static final String SWAGGER = "swagger";

    private SwaggerWsdlHelper() {
    }

    public static String readSwaggerStreamToString(InputStream swaggerDefinitionStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(swaggerDefinitionStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int result = bufferedInputStream.read();
        while (result != -1) {
            byteArrayOutputStream.write((byte)result);
            result = bufferedInputStream.read();
        }
        String streamAsString = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name());
        swaggerDefinitionStream.close();
        bufferedInputStream.close();
        byteArrayOutputStream.close();
        return streamAsString;
    }

    public static String convertYamlToJson(String yamlString) throws IOException {
        ObjectMapper jsonWriter = new ObjectMapper();
        ObjectMapper yamlReader = new ObjectMapper((JsonFactory)new YAMLFactory());
        Object yaml = yamlReader.readValue(yamlString, Object.class);
        return jsonWriter.writeValueAsString(yaml);
    }

    public static String updateSwaggerDefinitionWithEndpoint(URL managedEndpoint, String swaggerDefinition, ApiVersionBean apiVersion, IStorage storage) throws IOException, StorageException {
        ObjectMapper jsonMapper = new ObjectMapper();
        JsonNode swaggerJsonNode = jsonMapper.readTree(swaggerDefinition);
        ObjectNode swaggerObjectNode = (ObjectNode)swaggerJsonNode;
        String host = swaggerJsonNode.path(HOST).asText("");
        String path = swaggerJsonNode.path(BASE_PATH).asText("");
        String endpointHost = managedEndpoint.getHost();
        String endpointPort = managedEndpoint.getPort() != -1 ? ":" + managedEndpoint.getPort() : "";
        String endpointPath = managedEndpoint.getPath();
        boolean updateStorage = false;
        if (!(swaggerJsonNode.findValue(SWAGGER) == null || host.equals(endpointHost + endpointPort) && path.equals(endpointPath))) {
            swaggerObjectNode.put(BASE_PATH, endpointPath);
            swaggerObjectNode.put(HOST, endpointHost + endpointPort);
            updateStorage = true;
        }
        String prettifiedSwaggerDefinition = SwaggerWsdlHelper.jsonNodeToString(swaggerJsonNode, apiVersion);
        if (updateStorage) {
            storage.updateApiDefinition(apiVersion, (InputStream)new ByteArrayInputStream(prettifiedSwaggerDefinition.getBytes(StandardCharsets.UTF_8)));
        }
        return prettifiedSwaggerDefinition;
    }

    private static String jsonNodeToString(JsonNode jsonNode, ApiVersionBean apiVersion) {
        String prettifiedSwaggerDefinition = null;
        try {
            if (apiVersion.getDefinitionType() == ApiDefinitionType.SwaggerJSON) {
                prettifiedSwaggerDefinition = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            } else if (apiVersion.getDefinitionType() == ApiDefinitionType.SwaggerYAML) {
                prettifiedSwaggerDefinition = new YAMLMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonNode);
            }
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return prettifiedSwaggerDefinition;
    }

    public static String updateLocationEndpointInWsdl(InputStream wsdlStream, URL managedEndpoint, ApiVersionBean apiVersion, IStorage storage) throws StorageException {
        Document document = SwaggerWsdlHelper.readWsdlInputStream(wsdlStream);
        Boolean updateStorage = false;
        LinkedList<Element> allSoapAddresses = new LinkedList<Element>();
        for (String soapNamespace : SOAP_NAMESPACES) {
            NodeList soapAddresses = document.getDocumentElement().getElementsByTagNameNS(soapNamespace, SOAP_ADDRESS);
            if (soapAddresses == null || soapAddresses.getLength() <= 0) continue;
            for (int j = 0; j < soapAddresses.getLength(); ++j) {
                allSoapAddresses.add((Element)soapAddresses.item(j));
            }
        }
        String endpoint = managedEndpoint.toString();
        for (Element addressElem : allSoapAddresses) {
            String location = addressElem.getAttribute(LOCATION);
            if (location.equals(endpoint)) continue;
            addressElem.setAttribute(LOCATION, endpoint);
            updateStorage = true;
        }
        String wsdl = SwaggerWsdlHelper.xmlDocumentToString(document);
        if (updateStorage.booleanValue()) {
            storage.updateApiDefinition(apiVersion, (InputStream)new ByteArrayInputStream(wsdl.getBytes(StandardCharsets.UTF_8)));
        }
        return wsdl;
    }

    private static Document readWsdlInputStream(InputStream wsdlStream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = null;
        Document document = null;
        try {
            documentBuilder = factory.newDocumentBuilder();
            document = documentBuilder.parse(wsdlStream);
            wsdlStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    private static String xmlDocumentToString(Document document) {
        String wsdlString = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(writer));
            wsdlString = writer.getBuffer().toString();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return wsdlString;
    }
}

