/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.manager.api.beans.apis.ApiBean;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiPlanBean;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.audit.AuditEntityType;
import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.audit.AuditEntryType;
import io.apiman.manager.api.beans.audit.data.ContractData;
import io.apiman.manager.api.beans.audit.data.EntityUpdatedData;
import io.apiman.manager.api.beans.audit.data.MembershipData;
import io.apiman.manager.api.beans.audit.data.PolicyData;
import io.apiman.manager.api.beans.clients.ClientBean;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.orgs.OrganizationBean;
import io.apiman.manager.api.beans.plans.PlanBean;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class AuditUtils {
    private static final ObjectMapper mapper = new ObjectMapper();

    private AuditUtils() {
    }

    public static boolean valueChanged(String before, String after) {
        if (before == null && after == null || after == null) {
            return false;
        }
        if (before == null) {
            return true;
        }
        return !before.trim().equals(after.trim());
    }

    public static boolean valueChanged(Boolean before, Boolean after) {
        if (before == null && after == null || after == null) {
            return false;
        }
        if (before == null) {
            return true;
        }
        return !before.equals(after);
    }

    public static boolean valueChanged(Set<?> before, Set<?> after) {
        if (before == null && after == null || after == null) {
            return false;
        }
        if (before == null) {
            return !after.isEmpty();
        }
        if (before.size() != after.size()) {
            return true;
        }
        for (Object bean : after) {
            if (before.contains(bean)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueChanged(Map<String, String> before, Map<String, String> after) {
        if (before == null && after == null || after == null) {
            return false;
        }
        if (before == null) {
            return !after.isEmpty();
        }
        if (before.size() != after.size()) {
            return true;
        }
        for (Map.Entry<String, String> entry : after.entrySet()) {
            String key = entry.getKey();
            String afterValue = entry.getValue();
            if (!before.containsKey(key)) {
                return true;
            }
            String beforeValue = before.get(key);
            if (!AuditUtils.valueChanged(beforeValue, afterValue)) continue;
            return true;
        }
        return false;
    }

    public static boolean valueChanged(Enum<?> before, Enum<?> after) {
        if (before == null && after == null) {
            return false;
        }
        if (after == null) {
            return false;
        }
        if (before == null && after != null) {
            return true;
        }
        return before != after;
    }

    public static AuditEntryBean organizationCreated(OrganizationBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getId(), AuditEntityType.Organization, securityContext);
        entry.setEntityId(null);
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean organizationUpdated(OrganizationBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getId(), AuditEntityType.Organization, securityContext);
        entry.setEntityId(null);
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean membershipGranted(String organizationId, MembershipData data, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(organizationId, AuditEntityType.Organization, securityContext);
        entry.setEntityId(null);
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Grant);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean membershipRevoked(String organizationId, MembershipData data, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(organizationId, AuditEntityType.Organization, securityContext);
        entry.setEntityId(null);
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Revoke);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean apiCreated(ApiBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getId());
        entry.setEntityVersion(null);
        entry.setData(null);
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean apiUpdated(ApiBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getId());
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean apiVersionCreated(ApiVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getApi().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean apiVersionUpdated(ApiVersionBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getApi().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean apiDefinitionUpdated(ApiVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getApi().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.UpdateDefinition);
        return entry;
    }

    public static AuditEntryBean apiDefinitionDeleted(ApiVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getApi().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.DeleteDefinition);
        return entry;
    }

    public static AuditEntryBean clientCreated(ClientBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(bean.getId());
        entry.setEntityVersion(null);
        entry.setData(null);
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean clientUpdated(ClientBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(bean.getId());
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean clientVersionCreated(ClientVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(bean.getClient().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean clientVersionUpdated(ClientVersionBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(bean.getClient().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean contractCreatedFromClient(ContractBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getClient().getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setWhat(AuditEntryType.CreateContract);
        entry.setEntityId(bean.getClient().getClient().getId());
        entry.setEntityVersion(bean.getClient().getVersion());
        ContractData data = new ContractData(bean);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean contractCreatedToApi(ContractBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setCreatedOn(new Date(entry.getCreatedOn().getTime() + 1L));
        entry.setWhat(AuditEntryType.CreateContract);
        entry.setEntityId(bean.getApi().getApi().getId());
        entry.setEntityVersion(bean.getApi().getVersion());
        ContractData data = new ContractData(bean);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean contractBrokenFromClient(ContractBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getClient().getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setWhat(AuditEntryType.BreakContract);
        entry.setEntityId(bean.getClient().getClient().getId());
        entry.setEntityVersion(bean.getClient().getVersion());
        ContractData data = new ContractData(bean);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean contractBrokenToApi(ContractBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setWhat(AuditEntryType.BreakContract);
        entry.setEntityId(bean.getApi().getApi().getId());
        entry.setEntityVersion(bean.getApi().getVersion());
        ContractData data = new ContractData(bean);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean policyAdded(PolicyBean bean, PolicyType type, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganizationId(), null, securityContext);
        entry.setWhat(AuditEntryType.AddPolicy);
        entry.setEntityId(bean.getEntityId());
        entry.setEntityVersion(bean.getEntityVersion());
        switch (type) {
            case Client: {
                entry.setEntityType(AuditEntityType.Client);
                break;
            }
            case Plan: {
                entry.setEntityType(AuditEntityType.Plan);
                break;
            }
            case Api: {
                entry.setEntityType(AuditEntityType.Api);
            }
        }
        PolicyData data = new PolicyData();
        data.setPolicyDefId(bean.getDefinition().getId());
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean policyRemoved(PolicyBean bean, PolicyType type, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganizationId(), null, securityContext);
        entry.setWhat(AuditEntryType.RemovePolicy);
        entry.setEntityId(bean.getEntityId());
        entry.setEntityVersion(bean.getEntityVersion());
        switch (type) {
            case Client: {
                entry.setEntityType(AuditEntityType.Client);
                break;
            }
            case Plan: {
                entry.setEntityType(AuditEntityType.Plan);
                break;
            }
            case Api: {
                entry.setEntityType(AuditEntityType.Api);
            }
        }
        PolicyData data = new PolicyData();
        data.setPolicyDefId(bean.getDefinition().getId());
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean policyUpdated(PolicyBean bean, PolicyType type, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganizationId(), null, securityContext);
        entry.setWhat(AuditEntryType.UpdatePolicy);
        entry.setEntityId(bean.getEntityId());
        entry.setEntityVersion(bean.getEntityVersion());
        switch (type) {
            case Client: {
                entry.setEntityType(AuditEntityType.Client);
                break;
            }
            case Plan: {
                entry.setEntityType(AuditEntityType.Plan);
                break;
            }
            case Api: {
                entry.setEntityType(AuditEntityType.Api);
            }
        }
        PolicyData data = new PolicyData();
        data.setPolicyDefId(bean.getDefinition().getId());
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    private static String toJSON(Object data) {
        try {
            return mapper.writeValueAsString(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AuditEntryBean planCreated(PlanBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganization().getId(), AuditEntityType.Plan, securityContext);
        entry.setEntityId(bean.getId());
        entry.setEntityVersion(null);
        entry.setData(null);
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean planUpdated(PlanBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getOrganization().getId(), AuditEntityType.Plan, securityContext);
        entry.setEntityId(bean.getId());
        entry.setEntityVersion(null);
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean planVersionCreated(PlanVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getPlan().getOrganization().getId(), AuditEntityType.Plan, securityContext);
        entry.setEntityId(bean.getPlan().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Create);
        return entry;
    }

    public static AuditEntryBean planVersionUpdated(PlanVersionBean bean, EntityUpdatedData data, ISecurityContext securityContext) {
        if (data.getChanges().isEmpty()) {
            return null;
        }
        AuditEntryBean entry = AuditUtils.newEntry(bean.getPlan().getOrganization().getId(), AuditEntityType.Plan, securityContext);
        entry.setEntityId(bean.getPlan().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Update);
        entry.setData(AuditUtils.toJSON(data));
        return entry;
    }

    public static AuditEntryBean apiPublished(ApiVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getApi().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Publish);
        return entry;
    }

    public static AuditEntryBean apiRetired(ApiVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(bean.getApi().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Retire);
        return entry;
    }

    public static AuditEntryBean clientRegistered(ClientVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(bean.getClient().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Register);
        return entry;
    }

    public static AuditEntryBean clientUnregistered(ClientVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(bean.getClient().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Unregister);
        return entry;
    }

    public static AuditEntryBean planLocked(PlanVersionBean bean, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(bean.getPlan().getOrganization().getId(), AuditEntityType.Plan, securityContext);
        entry.setEntityId(bean.getPlan().getId());
        entry.setEntityVersion(bean.getVersion());
        entry.setWhat(AuditEntryType.Lock);
        return entry;
    }

    public static AuditEntryBean policiesReordered(ApiVersionBean apiVersion, PolicyType policyType, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(apiVersion.getApi().getOrganization().getId(), AuditEntityType.Api, securityContext);
        entry.setEntityId(apiVersion.getApi().getId());
        entry.setEntityVersion(apiVersion.getVersion());
        entry.setWhat(AuditEntryType.ReorderPolicies);
        return entry;
    }

    public static AuditEntryBean policiesReordered(ClientVersionBean cvb, PolicyType policyType, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(cvb.getClient().getOrganization().getId(), AuditEntityType.Client, securityContext);
        entry.setEntityId(cvb.getClient().getId());
        entry.setEntityVersion(cvb.getVersion());
        entry.setWhat(AuditEntryType.ReorderPolicies);
        return entry;
    }

    public static AuditEntryBean policiesReordered(PlanVersionBean pvb, PolicyType policyType, ISecurityContext securityContext) {
        AuditEntryBean entry = AuditUtils.newEntry(pvb.getPlan().getOrganization().getId(), AuditEntityType.Plan, securityContext);
        entry.setEntityId(pvb.getPlan().getId());
        entry.setEntityVersion(pvb.getVersion());
        entry.setWhat(AuditEntryType.ReorderPolicies);
        return entry;
    }

    private static AuditEntryBean newEntry(String orgId, AuditEntityType type, ISecurityContext securityContext) {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        AuditEntryBean entry = new AuditEntryBean();
        entry.setOrganizationId(orgId);
        entry.setEntityType(type);
        entry.setCreatedOn(new Date());
        entry.setWho(securityContext.getCurrentUser());
        return entry;
    }

    public static String asString_ApiPlanBeans(Set<ApiPlanBean> plans) {
        TreeSet<ApiPlanBean> sortedPlans = new TreeSet<ApiPlanBean>(new Comparator<ApiPlanBean>(){

            @Override
            public int compare(ApiPlanBean o1, ApiPlanBean o2) {
                String p1 = o1.getPlanId() + ":" + o1.getVersion();
                String p2 = o2.getPlanId() + ":" + o2.getVersion();
                return p1.compareTo(p2);
            }
        });
        sortedPlans.addAll(plans);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        if (plans != null) {
            for (ApiPlanBean plan : sortedPlans) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(plan.getPlanId()).append(":").append(plan.getVersion());
                first = false;
            }
        }
        return builder.toString();
    }

    public static String asString_ApiGatewayBeans(Set<ApiGatewayBean> gateways) {
        TreeSet<ApiGatewayBean> sortedGateways = new TreeSet<ApiGatewayBean>(new Comparator<ApiGatewayBean>(){

            @Override
            public int compare(ApiGatewayBean o1, ApiGatewayBean o2) {
                return o1.getGatewayId().compareTo(o2.getGatewayId());
            }
        });
        sortedGateways.addAll(gateways);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        if (gateways != null) {
            for (ApiGatewayBean gateway : sortedGateways) {
                if (!first) {
                    builder.append(", ");
                }
                builder.append(gateway.getGatewayId());
                first = false;
            }
        }
        return builder.toString();
    }
}

