/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.audit.AuditEntryBean;
import io.apiman.manager.api.beans.idm.CurrentUserBean;
import io.apiman.manager.api.beans.idm.PermissionBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleMembershipBean;
import io.apiman.manager.api.beans.idm.UpdateUserBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.idm.UserPermissionsBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.INewUserBootstrapper;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IUserResource;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class UserResourceImpl
implements IUserResource {
    @Inject
    private IStorage storage;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IStorageQuery query;
    @Inject
    private INewUserBootstrapper userBootstrapper;

    public UserBean get(String userId) throws UserNotFoundException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getUserInternal(userId);
    }

    public CurrentUserBean getInfo() {
        String userId = this.securityContext.getCurrentUser();
        try {
            CurrentUserBean currentUser = new CurrentUserBean();
            UserBean user = this.getUserInternal(userId);
            if (user == null) {
                user = new UserBean();
                user.setUsername(userId);
                if (this.securityContext.getFullName() != null) {
                    user.setFullName(this.securityContext.getFullName());
                } else {
                    user.setFullName(userId);
                }
                if (this.securityContext.getEmail() != null) {
                    user.setEmail(this.securityContext.getEmail());
                } else {
                    user.setEmail("");
                }
                user.setJoinedOn(new Date());
                this.storage.beginTx();
                try {
                    this.storage.createUser(user);
                    this.userBootstrapper.bootstrapUser(user, this.storage);
                    this.storage.commitTx();
                }
                catch (StorageException e1) {
                    this.storage.rollbackTx();
                    throw new SystemErrorException((Throwable)e1);
                }
                currentUser.setPermissions(new HashSet());
            } else {
                Set permissions = this.query.getPermissions(userId);
                currentUser.setPermissions(permissions);
            }
            currentUser.initFromUser(user);
            currentUser.setAdmin(this.securityContext.isAdmin());
            return currentUser;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    private UserBean getUserInternal(String userId) {
        try {
            UserBean user;
            this.storage.beginTx();
            UserBean userBean = user = this.storage.getUser(userId);
            return userBean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        finally {
            this.storage.rollbackTx();
        }
    }

    public void update(String userId, UpdateUserBean user) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        try {
            UserBean updatedUser = this.getUserInternal(userId);
            if (updatedUser == null) {
                throw ExceptionFactory.userNotFoundException((String)userId);
            }
            if (user.getEmail() != null) {
                updatedUser.setEmail(user.getEmail());
            }
            if (user.getFullName() != null) {
                updatedUser.setFullName(user.getFullName());
            }
            this.storage.beginTx();
            this.storage.updateUser(updatedUser);
            this.storage.commitTx();
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<OrganizationSummaryBean> getOrganizations(String userId) throws NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        HashSet<String> permittedOrganizations = new HashSet<String>();
        try {
            Set memberships = this.query.getUserMemberships(userId);
            for (RoleMembershipBean membership : memberships) {
                permittedOrganizations.add(membership.getOrganizationId());
            }
            return this.query.getOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ClientSummaryBean> getClients(String userId) throws NotAuthorizedException, SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getClientsInternal(userId, PermissionType.clientView);
    }

    public List<ClientSummaryBean> getEditableClients(String userId) throws NotAuthorizedException, SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getClientsInternal(userId, PermissionType.clientEdit);
    }

    private List<ClientSummaryBean> getClientsInternal(String userId, PermissionType permissionType) throws SystemErrorException {
        try {
            return this.query.getClientsInOrgs(this.getPermittedOrganizations(userId, permissionType));
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiSummaryBean> getApis(String userId) throws NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        Set<String> permittedOrganizations = this.getPermittedOrganizations(userId, PermissionType.apiView);
        try {
            return this.query.getApisInOrgs(permittedOrganizations);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AuditEntryBean> getActivity(String userId, int page, int pageSize) throws NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        if (page <= 1) {
            page = 1;
        }
        if (pageSize == 0) {
            pageSize = 20;
        }
        try {
            PagingBean paging = new PagingBean();
            paging.setPage(page);
            paging.setPageSize(pageSize);
            SearchResultsBean rval = this.query.auditUser(userId, paging);
            return rval;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public UserPermissionsBean getPermissionsForUser(String userId) throws UserNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        try {
            UserPermissionsBean bean = new UserPermissionsBean();
            bean.setUserId(userId);
            bean.setPermissions(this.query.getPermissions(userId));
            return bean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<OrganizationSummaryBean> getClientOrganizations(String userId) throws SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getOrganizationsInternal(userId, PermissionType.clientEdit);
    }

    public List<OrganizationSummaryBean> getApiOrganizations(String userId) throws SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getOrganizationsInternal(userId, PermissionType.apiEdit);
    }

    public List<OrganizationSummaryBean> getPlanOrganizations(String userId) throws SystemErrorException {
        this.securityContext.checkIfUserIsCurrentUser(userId);
        return this.getOrganizationsInternal(userId, PermissionType.planEdit);
    }

    private Set<String> getPermittedOrganizations(String userId, PermissionType permissionType) throws SystemErrorException {
        HashSet<String> permittedOrganizations = new HashSet<String>();
        try {
            Set permissions = this.query.getPermissions(userId);
            for (PermissionBean permission : permissions) {
                if (permission.getName() != permissionType) continue;
                permittedOrganizations.add(permission.getOrganizationId());
            }
            return permittedOrganizations;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    private List<OrganizationSummaryBean> getOrganizationsInternal(String userId, PermissionType permissionType) throws SystemErrorException {
        try {
            return this.query.getOrgs(this.getPermittedOrganizations(userId, permissionType));
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }
}

