/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.UserBean;
import io.apiman.manager.api.beans.search.PagingBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterBean;
import io.apiman.manager.api.beans.search.SearchCriteriaFilterOperator;
import io.apiman.manager.api.beans.search.SearchResultsBean;
import io.apiman.manager.api.beans.search.searchResults.UserSearchResult;
import io.apiman.manager.api.beans.summary.ApiNamespaceBean;
import io.apiman.manager.api.beans.summary.ApiSummaryBean;
import io.apiman.manager.api.beans.summary.AvailableApiBean;
import io.apiman.manager.api.beans.summary.ClientSummaryBean;
import io.apiman.manager.api.beans.summary.OrganizationSummaryBean;
import io.apiman.manager.api.core.IApiCatalog;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.ISearchResource;
import io.apiman.manager.api.rest.exceptions.InvalidSearchCriteriaException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.rest.impl.util.SearchCriteriaUtil;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class SearchResourceImpl
implements ISearchResource {
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    IApiCatalog apiCatalog;
    @Inject
    ISecurityContext securityContext;

    public SearchResultsBean<OrganizationSummaryBean> searchOrgs(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        try {
            return this.query.findOrganizations(criteria);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<ClientSummaryBean> searchClients(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        try {
            return this.query.findClients(criteria);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<ApiSummaryBean> searchApis(SearchCriteriaBean criteria) throws OrganizationNotFoundException, InvalidSearchCriteriaException {
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        try {
            if (this.securityContext.isAdmin()) {
                return this.query.findApis(criteria);
            }
            List<ApiSummaryBean> apis = RestHelper.hideSensitiveDataFromApiSummaryBeanList(this.query.findApis(criteria).getBeans());
            SearchResultsBean result = new SearchResultsBean();
            result.setBeans(apis);
            result.setTotalSize(apis.size());
            return result;
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<AvailableApiBean> searchApiCatalog(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        int totalSize;
        int pageSize;
        int page;
        int start;
        SearchCriteriaUtil.validateSearchCriteria(criteria);
        SearchResultsBean rval = new SearchResultsBean();
        if (criteria.getFilters().isEmpty()) {
            return rval;
        }
        SearchCriteriaFilterBean bean = (SearchCriteriaFilterBean)criteria.getFilters().get(0);
        if (bean == null) {
            return rval;
        }
        if (!bean.getName().equals("name")) {
            return rval;
        }
        String keyword = bean.getValue();
        String namespace = null;
        if (criteria.getFilters().size() >= 2 && (bean = (SearchCriteriaFilterBean)criteria.getFilters().get(1)) != null && bean.getName().equals("namespace") && bean.getOperator() == SearchCriteriaFilterOperator.eq) {
            namespace = bean.getValue();
        }
        List catalogEntries = this.apiCatalog.search(keyword, namespace);
        ArrayList<AvailableApiBean> apis = new ArrayList<AvailableApiBean>();
        if (this.securityContext.getPermittedOrganizations(PermissionType.apiEdit).isEmpty() && !this.securityContext.isAdmin()) {
            for (AvailableApiBean api : catalogEntries) {
                AvailableApiBean entry = new AvailableApiBean();
                entry.setId(api.getId());
                entry.setIcon(api.getIcon());
                entry.setRouteEndpoint(api.getRouteEndpoint());
                entry.setEndpointType(api.getEndpointType());
                entry.setName(api.getName());
                entry.setDescription(api.getDescription());
                entry.setDefinitionType(api.getDefinitionType());
                entry.setNamespace(api.getNamespace());
                entry.setTags(api.getTags());
                entry.setInternal(api.isInternal());
                apis.add(entry);
            }
        } else {
            apis.addAll(catalogEntries);
        }
        PagingBean paging = criteria.getPaging();
        if (paging == null) {
            paging = new PagingBean();
            paging.setPage(1);
            paging.setPageSize(500);
        }
        if ((start = ((page = paging.getPage()) - 1) * (pageSize = paging.getPageSize())) <= (totalSize = apis.size())) {
            int end = Math.min(start + pageSize, apis.size());
            rval.getBeans().addAll(apis.subList(start, end));
        }
        rval.setTotalSize(totalSize);
        return rval;
    }

    public SearchResultsBean<UserSearchResult> searchUsers(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        ArrayList<UserSearchResult> users = new ArrayList<UserSearchResult>();
        try {
            List userBeans = this.query.findUsers(criteria).getBeans();
            for (UserBean user : userBeans) {
                users.add(new UserSearchResult(user.getUsername(), user.getFullName()));
            }
            SearchResultsBean searchResultsBean = new SearchResultsBean();
            searchResultsBean.setBeans(users);
            searchResultsBean.setTotalSize(users.size());
            return searchResultsBean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public SearchResultsBean<RoleBean> searchRoles(SearchCriteriaBean criteria) throws InvalidSearchCriteriaException {
        try {
            SearchCriteriaUtil.validateSearchCriteria(criteria);
            ArrayList<RoleBean> roles = new ArrayList<RoleBean>();
            for (RoleBean bean : this.getQuery().findRoles(criteria).getBeans()) {
                roles.add(RestHelper.hideSensitiveDataFromRoleBean(this.securityContext, bean));
            }
            SearchResultsBean result = new SearchResultsBean();
            result.setBeans(roles);
            result.setTotalSize(roles.size());
            return result;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ApiNamespaceBean> getApiNamespaces() {
        return this.apiCatalog.getNamespaces(this.securityContext.getCurrentUser());
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }
}

