/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.idm.NewRoleBean;
import io.apiman.manager.api.beans.idm.RoleBean;
import io.apiman.manager.api.beans.idm.UpdateRoleBean;
import io.apiman.manager.api.beans.search.SearchCriteriaBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IRoleResource;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.RoleAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.util.RestHelper;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class RoleResourceImpl
implements IRoleResource {
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;

    public RoleBean create(NewRoleBean bean) throws RoleAlreadyExistsException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        RoleBean role = new RoleBean();
        role.setAutoGrant(bean.getAutoGrant());
        role.setCreatedBy(this.securityContext.getCurrentUser());
        role.setCreatedOn(new Date());
        role.setDescription(bean.getDescription());
        role.setId(BeanUtils.idFromName((String)bean.getName()));
        role.setName(bean.getName());
        role.setPermissions(bean.getPermissions());
        try {
            this.getStorage().beginTx();
            if (this.getStorage().getRole(role.getId()) != null) {
                throw ExceptionFactory.roleAlreadyExistsException((String)role.getId());
            }
            this.getStorage().createRole(role);
            this.getStorage().commitTx();
            return role;
        }
        catch (StorageException e) {
            this.getStorage().rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public RoleBean get(String roleId) throws RoleNotFoundException {
        try {
            this.getStorage().beginTx();
            RoleBean role = this.getRoleFromStorage(roleId);
            RoleBean roleBean = RestHelper.hideSensitiveDataFromRoleBean(this.securityContext, role);
            return roleBean;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
        finally {
            this.getStorage().rollbackTx();
        }
    }

    public void update(String roleId, UpdateRoleBean bean) throws RoleNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.getStorage().beginTx();
            RoleBean role = this.getRoleFromStorage(roleId);
            if (bean.getDescription() != null) {
                role.setDescription(bean.getDescription());
            }
            if (bean.getAutoGrant() != null) {
                role.setAutoGrant(bean.getAutoGrant());
            }
            if (bean.getName() != null) {
                role.setName(bean.getName());
            }
            if (bean.getPermissions() != null) {
                role.getPermissions().clear();
                role.getPermissions().addAll(bean.getPermissions());
            }
            this.getStorage().updateRole(role);
            this.getStorage().commitTx();
        }
        catch (StorageException e) {
            this.getStorage().rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    private RoleBean getRoleFromStorage(String roleId) throws StorageException, RoleNotFoundException {
        RoleBean role = this.getStorage().getRole(roleId);
        if (role == null) {
            throw ExceptionFactory.roleNotFoundException((String)roleId);
        }
        return role;
    }

    public void delete(String roleId) throws RoleNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        RoleBean bean = this.get(roleId);
        try {
            this.getStorage().beginTx();
            this.getStorage().deleteRole(bean);
            this.getStorage().commitTx();
        }
        catch (StorageException e) {
            this.getStorage().rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<RoleBean> list() {
        try {
            SearchCriteriaBean criteria = new SearchCriteriaBean();
            criteria.setOrder("name", true);
            if (this.securityContext.isAdmin()) {
                return this.getQuery().findRoles(criteria).getBeans();
            }
            ArrayList<RoleBean> roles = new ArrayList<RoleBean>();
            for (RoleBean role : this.getQuery().findRoles(criteria).getBeans()) {
                roles.add(RestHelper.hideSensitiveDataFromRoleBean(this.securityContext, role));
            }
            return roles;
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }
}

