/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.plugin.Plugin;
import io.apiman.common.plugin.PluginClassLoader;
import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.common.plugin.PluginUtils;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.plugins.NewPluginBean;
import io.apiman.manager.api.beans.plugins.PluginBean;
import io.apiman.manager.api.beans.plugins.PluginRegistryBean;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.summary.PluginSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyFormType;
import io.apiman.manager.api.core.IPluginRegistry;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.config.ApiManagerConfig;
import io.apiman.manager.api.core.exceptions.InvalidPluginException;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.IPluginResource;
import io.apiman.manager.api.rest.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.PluginAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.PluginNotFoundException;
import io.apiman.manager.api.rest.exceptions.PluginResourceNotFoundException;
import io.apiman.manager.api.rest.exceptions.PolicyDefinitionNotFoundException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;

@ApplicationScoped
public class PluginResourceImpl
implements IPluginResource {
    private final IApimanLogger log = ApimanLoggerFactory.getLogger(PluginResourceImpl.class);
    private static final ObjectMapper mapper = new ObjectMapper();
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IPluginRegistry pluginRegistry;
    @Inject
    ApiManagerConfig config;
    private Map<URI, PluginRegistryBean> registryCache = new HashMap<URI, PluginRegistryBean>();

    public List<PluginSummaryBean> list() throws NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            return this.query.listPlugins();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PluginBean create(NewPluginBean bean) throws PluginAlreadyExistsException, PluginNotFoundException, NotAuthorizedException {
        Plugin plugin;
        this.securityContext.checkAdminPermissions();
        PluginCoordinates coordinates = new PluginCoordinates(bean.getGroupId(), bean.getArtifactId(), bean.getVersion(), bean.getClassifier(), bean.getType());
        boolean isSnapshot = PluginUtils.isSnapshot((PluginCoordinates)coordinates);
        if (isSnapshot) {
            this.log.debug("Loading a snapshot version of plugin: " + coordinates);
        }
        boolean isUpgrade = isSnapshot || bean.isUpgrade();
        try {
            plugin = this.pluginRegistry.loadPlugin(coordinates);
            bean.setName(plugin.getName());
            bean.setDescription(plugin.getDescription());
        }
        catch (InvalidPluginException e) {
            throw new PluginNotFoundException(coordinates.toString(), (Throwable)e);
        }
        PluginBean pluginBean = new PluginBean();
        pluginBean.setGroupId(bean.getGroupId());
        pluginBean.setArtifactId(bean.getArtifactId());
        pluginBean.setVersion(bean.getVersion());
        pluginBean.setClassifier(bean.getClassifier());
        pluginBean.setType(bean.getType());
        pluginBean.setName(bean.getName());
        pluginBean.setDescription(bean.getDescription());
        pluginBean.setCreatedBy(this.securityContext.getCurrentUser());
        pluginBean.setCreatedOn(new Date());
        try {
            this.storage.beginTx();
            PluginBean existingPlugin = this.storage.getPlugin(bean.getGroupId(), bean.getArtifactId());
            boolean hasExistingPlugin = existingPlugin != null && !existingPlugin.isDeleted();
            boolean isUpdatePolicyDefs = false;
            if (hasExistingPlugin && !isUpgrade) {
                throw ExceptionFactory.pluginAlreadyExistsException();
            }
            if (hasExistingPlugin && isUpgrade) {
                isUpdatePolicyDefs = true;
                existingPlugin.setName(pluginBean.getName());
                existingPlugin.setDescription(pluginBean.getDescription());
                existingPlugin.setVersion(pluginBean.getVersion());
                existingPlugin.setClassifier(pluginBean.getClassifier());
                existingPlugin.setType(pluginBean.getType());
                pluginBean.setId(existingPlugin.getId());
                this.storage.updatePlugin(existingPlugin);
            } else if (!hasExistingPlugin && existingPlugin != null) {
                isUpdatePolicyDefs = true;
                existingPlugin.setName(pluginBean.getName());
                existingPlugin.setDescription(pluginBean.getDescription());
                existingPlugin.setVersion(pluginBean.getVersion());
                existingPlugin.setClassifier(pluginBean.getClassifier());
                existingPlugin.setType(pluginBean.getType());
                existingPlugin.setCreatedOn(new Date());
                existingPlugin.setCreatedBy(this.securityContext.getCurrentUser());
                existingPlugin.setDeleted(Boolean.valueOf(false));
                pluginBean.setId(existingPlugin.getId());
                this.storage.updatePlugin(existingPlugin);
            } else {
                if (bean.isUpgrade()) {
                    throw ExceptionFactory.pluginNotFoundException((Long)0L);
                }
                this.storage.createPlugin(pluginBean);
            }
            List policyDefs = plugin.getPolicyDefinitions();
            int createdPolicyDefCounter = 0;
            int updatedPolicyDefCounter = 0;
            for (URL url : policyDefs) {
                PolicyDefinitionBean existingPolicyDef;
                PolicyDefinitionBean policyDef = (PolicyDefinitionBean)mapper.reader(PolicyDefinitionBean.class).readValue(url);
                if (policyDef.getId() == null || policyDef.getId().trim().isEmpty()) {
                    throw ExceptionFactory.policyDefInvalidException((String)Messages.i18n.format("PluginResourceImpl.MissingPolicyDefId", new Object[]{policyDef.getName()}));
                }
                policyDef.setPluginId(pluginBean.getId());
                if (policyDef.getId() == null) {
                    policyDef.setId(BeanUtils.idFromName((String)policyDef.getName()));
                } else {
                    policyDef.setId(BeanUtils.idFromName((String)policyDef.getId()));
                }
                if (policyDef.getFormType() == null) {
                    policyDef.setFormType(PolicyFormType.Default);
                }
                if ((existingPolicyDef = this.storage.getPolicyDefinition(policyDef.getId())) == null) {
                    this.storage.createPolicyDefinition(policyDef);
                    ++createdPolicyDefCounter;
                    continue;
                }
                if (isUpdatePolicyDefs) {
                    existingPolicyDef.setName(policyDef.getName());
                    existingPolicyDef.setDescription(policyDef.getDescription());
                    existingPolicyDef.setIcon(policyDef.getIcon());
                    existingPolicyDef.getTemplates().clear();
                    existingPolicyDef.getTemplates().addAll(policyDef.getTemplates());
                    existingPolicyDef.setFormType(policyDef.getFormType());
                    existingPolicyDef.setForm(policyDef.getForm());
                    existingPolicyDef.setDeleted(Boolean.valueOf(false));
                    existingPolicyDef.setPolicyImpl(policyDef.getPolicyImpl());
                    this.storage.updatePolicyDefinition(existingPolicyDef);
                    ++updatedPolicyDefCounter;
                    continue;
                }
                throw ExceptionFactory.policyDefInvalidException((String)Messages.i18n.format("PluginResourceImpl.DuplicatePolicyDef", new Object[]{policyDef.getId()}));
            }
            this.storage.commitTx();
            this.log.info(String.format("Created plugin mvn:%s:%s:%s", pluginBean.getGroupId(), pluginBean.getArtifactId(), pluginBean.getVersion()));
            this.log.info(String.format("\tCreated %s policy definitions from plugin.", String.valueOf(createdPolicyDefCounter)));
            if (isUpdatePolicyDefs) {
                this.log.info(String.format("\tUpdated %s policy definitions from plugin.", String.valueOf(updatedPolicyDefCounter)));
            }
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return pluginBean;
    }

    public PluginBean get(Long pluginId) throws PluginNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            PluginBean bean = this.storage.getPlugin(pluginId.longValue());
            if (bean == null) {
                throw ExceptionFactory.pluginNotFoundException((Long)pluginId);
            }
            this.storage.commitTx();
            return bean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(Long pluginId) throws PluginNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            List policyDefs = this.query.listPluginPolicyDefs(pluginId);
            this.storage.beginTx();
            PluginBean pbean = this.storage.getPlugin(pluginId.longValue());
            if (pbean == null) {
                throw ExceptionFactory.pluginNotFoundException((Long)pluginId);
            }
            pbean.setDeleted(Boolean.valueOf(true));
            this.storage.updatePlugin(pbean);
            for (PolicyDefinitionSummaryBean policyDef : policyDefs) {
                PolicyDefinitionBean definition = this.storage.getPolicyDefinition(policyDef.getId());
                if (definition == null) continue;
                definition.setDeleted(Boolean.valueOf(true));
                this.storage.updatePolicyDefinition(definition);
            }
            this.storage.commitTx();
            this.log.info(String.format("Deleted plugin mvn:%s:%s:%s", pbean.getGroupId(), pbean.getArtifactId(), pbean.getVersion()));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<PolicyDefinitionSummaryBean> getPolicyDefs(Long pluginId) throws PluginNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        this.get(pluginId);
        try {
            return this.query.listPluginPolicyDefs(pluginId);
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPolicyForm(Long pluginId, String policyDefId) throws PluginNotFoundException, PluginResourceNotFoundException, PolicyDefinitionNotFoundException {
        String string;
        PolicyDefinitionBean pdBean;
        PluginBean pbean;
        try {
            this.storage.beginTx();
            pbean = this.storage.getPlugin(pluginId.longValue());
            if (pbean == null) {
                throw ExceptionFactory.pluginNotFoundException((Long)pluginId);
            }
            pdBean = this.storage.getPolicyDefinition(policyDefId);
            this.storage.rollbackTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        PluginCoordinates coordinates = new PluginCoordinates(pbean.getGroupId(), pbean.getArtifactId(), pbean.getVersion(), pbean.getClassifier(), pbean.getType());
        if (pdBean == null) {
            throw ExceptionFactory.policyDefNotFoundException((String)policyDefId);
        }
        if (pdBean.getPluginId() == null || !pdBean.getPluginId().equals(pbean.getId())) {
            throw ExceptionFactory.pluginNotFoundException((Long)pluginId);
        }
        if (pdBean.getFormType() != PolicyFormType.JsonSchema || pdBean.getForm() == null) throw ExceptionFactory.pluginResourceNotFoundException(null, (PluginCoordinates)coordinates);
        String formPath = pdBean.getForm();
        formPath = !formPath.startsWith("/") ? "META-INF/apiman/policyDefs/" + formPath : formPath.substring(1);
        Plugin plugin = this.pluginRegistry.loadPlugin(coordinates);
        PluginClassLoader loader = plugin.getLoader();
        InputStream resource = null;
        try {
            resource = loader.getResourceAsStream(formPath);
            if (resource == null) {
                throw ExceptionFactory.pluginResourceNotFoundException((String)formPath, (PluginCoordinates)coordinates);
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)resource, (Writer)writer);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)resource);
                throw throwable;
            }
            catch (AbstractRestException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new SystemErrorException(t);
            }
        }
        IOUtils.closeQuietly((InputStream)resource);
        return string;
    }

    public List<PluginSummaryBean> getAvailablePlugins() throws NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        ArrayList<PluginSummaryBean> rval = new ArrayList<PluginSummaryBean>();
        Set registries = this.config.getPluginRegistries();
        for (URI registryUrl : registries) {
            PluginRegistryBean registry = this.loadRegistry(registryUrl);
            if (registry == null) {
                System.out.println("WARN: plugin registry failed to load - " + registryUrl);
                continue;
            }
            rval.addAll(registry.getPlugins());
        }
        Collections.sort(rval, new Comparator<PluginSummaryBean>(){

            @Override
            public int compare(PluginSummaryBean o1, PluginSummaryBean o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        return rval;
    }

    private PluginRegistryBean loadRegistry(URI registryUrl) {
        PluginRegistryBean fromCache = this.registryCache.get(registryUrl);
        if (fromCache != null) {
            return fromCache;
        }
        try {
            PluginRegistryBean registry = (PluginRegistryBean)mapper.reader(PluginRegistryBean.class).readValue(registryUrl.toURL());
            this.registryCache.put(registryUrl, registry);
            return registry;
        }
        catch (IOException e) {
            return null;
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

