/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.util.crypt.DataEncryptionContext;
import io.apiman.common.util.crypt.IDataEncrypter;
import io.apiman.gateway.engine.beans.GatewayEndpoint;
import io.apiman.gateway.engine.beans.SystemStatus;
import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.gateways.GatewayType;
import io.apiman.manager.api.beans.gateways.NewGatewayBean;
import io.apiman.manager.api.beans.gateways.RestGatewayConfigBean;
import io.apiman.manager.api.beans.gateways.UpdateGatewayBean;
import io.apiman.manager.api.beans.summary.GatewayEndpointSummaryBean;
import io.apiman.manager.api.beans.summary.GatewaySummaryBean;
import io.apiman.manager.api.beans.summary.GatewayTestResultBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.GatewayAuthenticationException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.IGatewayResource;
import io.apiman.manager.api.rest.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.exceptions.GatewayAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class GatewayResourceImpl
implements IGatewayResource {
    private final IApimanLogger log = ApimanLoggerFactory.getLogger(GatewayResourceImpl.class);
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IGatewayLinkFactory gatewayLinkFactory;
    @Inject
    IDataEncrypter encrypter;
    private static final ObjectMapper mapper = new ObjectMapper();

    public GatewayTestResultBean test(NewGatewayBean gatewayToTest) throws NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        GatewayTestResultBean rval = new GatewayTestResultBean();
        try {
            GatewayBean testGateway = new GatewayBean();
            testGateway.setName(gatewayToTest.getName());
            testGateway.setType(gatewayToTest.getType());
            testGateway.setConfiguration(gatewayToTest.getConfiguration());
            IGatewayLink gatewayLink = this.gatewayLinkFactory.create(testGateway);
            SystemStatus status = gatewayLink.getStatus();
            String detail = mapper.writer().writeValueAsString((Object)status);
            rval.setSuccess(true);
            rval.setDetail(detail);
        }
        catch (GatewayAuthenticationException e) {
            rval.setSuccess(false);
            rval.setDetail(Messages.i18n.format("GatewayResourceImpl.AuthenticationFailed", new Object[0]));
        }
        catch (Exception e) {
            rval.setSuccess(false);
            rval.setDetail(e.getMessage());
        }
        return rval;
    }

    public List<GatewaySummaryBean> list() {
        try {
            return this.query.listGateways();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public GatewayBean create(NewGatewayBean gatewayToInsert) throws GatewayAlreadyExistsException {
        this.securityContext.checkAdminPermissions();
        Date now = new Date();
        GatewayBean gateway = new GatewayBean();
        gateway.setId(BeanUtils.idFromName((String)gatewayToInsert.getName()));
        gateway.setName(gatewayToInsert.getName());
        gateway.setDescription(gatewayToInsert.getDescription());
        gateway.setType(gatewayToInsert.getType());
        gateway.setConfiguration(gatewayToInsert.getConfiguration());
        gateway.setCreatedBy(this.securityContext.getCurrentUser());
        gateway.setCreatedOn(now);
        gateway.setModifiedBy(this.securityContext.getCurrentUser());
        gateway.setModifiedOn(now);
        try {
            this.storage.beginTx();
            if (this.storage.getGateway(gateway.getId()) != null) {
                throw ExceptionFactory.gatewayAlreadyExistsException((String)gateway.getName());
            }
            this.encryptPasswords(gateway);
            this.storage.createGateway(gateway);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        this.decryptPasswords(gateway);
        this.log.debug(String.format("Successfully created new gateway %s: %s", gateway.getName(), gateway));
        return gateway;
    }

    public GatewayBean get(String gatewayId) throws GatewayNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            GatewayBean gateway = this.storage.getGateway(gatewayId);
            if (gateway == null) {
                throw ExceptionFactory.gatewayNotFoundException((String)gatewayId);
            }
            this.decryptPasswords(gateway);
            this.storage.commitTx();
            this.log.debug(String.format("Successfully fetched gateway %s: %s", gateway.getName(), gateway));
            return gateway;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public GatewayEndpointSummaryBean getGatewayEndpoint(String gatewayId) throws GatewayNotFoundException {
        try {
            this.storage.beginTx();
            GatewayBean gateway = this.storage.getGateway(gatewayId);
            if (gateway == null) {
                throw ExceptionFactory.gatewayNotFoundException((String)gatewayId);
            }
            this.log.debug(String.format("Got endpoint summary: %s", gateway));
            IGatewayLink link = this.gatewayLinkFactory.create(gateway);
            GatewayEndpoint endpoint = link.getGatewayEndpoint();
            GatewayEndpointSummaryBean gatewayEndpoint = new GatewayEndpointSummaryBean();
            gatewayEndpoint.setEndpoint(endpoint.getEndpoint());
            this.storage.commitTx();
            return gatewayEndpoint;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void update(String gatewayId, UpdateGatewayBean gatewayToUpdate) throws GatewayNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            Date now = new Date();
            GatewayBean gateway = this.storage.getGateway(gatewayId);
            if (gateway == null) {
                throw ExceptionFactory.gatewayNotFoundException((String)gatewayId);
            }
            gateway.setModifiedBy(this.securityContext.getCurrentUser());
            gateway.setModifiedOn(now);
            if (gatewayToUpdate.getDescription() != null) {
                gateway.setDescription(gatewayToUpdate.getDescription());
            }
            if (gatewayToUpdate.getType() != null) {
                gateway.setType(gatewayToUpdate.getType());
            }
            if (gatewayToUpdate.getConfiguration() != null) {
                gateway.setConfiguration(gatewayToUpdate.getConfiguration());
            }
            this.encryptPasswords(gateway);
            this.storage.updateGateway(gateway);
            this.storage.commitTx();
            this.log.debug(String.format("Successfully updated gateway %s: %s", gateway.getName(), gateway));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(String gatewayId) throws GatewayNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            GatewayBean gateway = this.storage.getGateway(gatewayId);
            if (gateway == null) {
                throw ExceptionFactory.gatewayNotFoundException((String)gatewayId);
            }
            this.storage.deleteGateway(gateway);
            this.storage.commitTx();
            this.log.debug(String.format("Successfully deleted gateway %s: %s", gateway.getName(), gateway));
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    private void encryptPasswords(GatewayBean gateway) {
        if (gateway.getConfiguration() == null) {
            return;
        }
        try {
            if (gateway.getType() == GatewayType.REST) {
                RestGatewayConfigBean config = (RestGatewayConfigBean)mapper.readValue(gateway.getConfiguration(), RestGatewayConfigBean.class);
                config.setPassword(this.encrypter.encrypt(config.getPassword(), new DataEncryptionContext()));
                gateway.setConfiguration(mapper.writeValueAsString((Object)config));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void decryptPasswords(GatewayBean gateway) {
        if (gateway.getConfiguration() == null) {
            return;
        }
        try {
            if (gateway.getType() == GatewayType.REST) {
                RestGatewayConfigBean config = (RestGatewayConfigBean)mapper.readValue(gateway.getConfiguration(), RestGatewayConfigBean.class);
                config.setPassword(this.encrypter.decrypt(config.getPassword(), new DataEncryptionContext()));
                gateway.setConfiguration(mapper.writeValueAsString((Object)config));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

