/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.developers.DeveloperBean;
import io.apiman.manager.api.beans.developers.DeveloperMappingBean;
import io.apiman.manager.api.beans.developers.UpdateDeveloperBean;
import io.apiman.manager.api.beans.summary.ClientVersionSummaryBean;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.IDeveloperResource;
import io.apiman.manager.api.rest.exceptions.DeveloperAlreadyExistsException;
import io.apiman.manager.api.rest.exceptions.DeveloperNotFoundException;
import io.apiman.manager.api.rest.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.OrganizationResourceImpl;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.core.Response;

public class DeveloperResourceImpl
implements IDeveloperResource {
    private final IApimanLogger log = ApimanLoggerFactory.getLogger(DeveloperResourceImpl.class);
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;
    @Inject
    IGatewayLinkFactory gatewayLinkFactory;
    private OrganizationResourceImpl organizationResource;

    public List<ApiVersionBean> getAllPublicApiVersions() throws NotAuthorizedException {
        ArrayList<ApiVersionBean> apiVersionBeans = new ArrayList<ApiVersionBean>();
        try {
            this.storage.beginTx();
            Iterator iterator = this.storage.getAllPublicApiVersions();
            this.storage.commitTx();
            while (iterator.hasNext()) {
                ApiVersionBean apiVersionBean = (ApiVersionBean)iterator.next();
                apiVersionBeans.add(apiVersionBean);
            }
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return apiVersionBeans;
    }

    public List<DeveloperBean> getDevelopers() throws NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        ArrayList<DeveloperBean> developerBeans = new ArrayList<DeveloperBean>();
        try {
            this.storage.beginTx();
            Iterator iterator = this.storage.getDevelopers();
            this.storage.commitTx();
            while (iterator.hasNext()) {
                DeveloperBean bean = (DeveloperBean)iterator.next();
                developerBeans.add(bean);
            }
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return developerBeans;
    }

    public DeveloperBean create(DeveloperBean bean) throws InvalidNameException, NotAuthorizedException, DeveloperAlreadyExistsException {
        this.securityContext.checkAdminPermissions();
        DeveloperBean developerBean = new DeveloperBean();
        developerBean.setId(bean.getId());
        developerBean.setClients(bean.getClients());
        try {
            this.storage.beginTx();
            if (this.storage.getDeveloper(bean.getId()) != null) {
                throw ExceptionFactory.developerAlreadyExistsException((String)bean.getId());
            }
            this.storage.createDeveloper(developerBean);
            this.storage.commitTx();
            this.log.debug(String.format("Created developer %s: %s", developerBean.getId(), developerBean));
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return developerBean;
    }

    public void update(String id, UpdateDeveloperBean bean) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            DeveloperBean developerBean = this.getDeveloperBeanFromStorage(id);
            developerBean.setClients(bean.getClients());
            this.storage.updateDeveloper(developerBean);
            this.storage.commitTx();
            this.log.debug(String.format("Updated developer %s: %s", developerBean.getId(), developerBean));
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public DeveloperBean get(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        DeveloperBean developerBean;
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            developerBean = this.getDeveloperBeanFromStorage(id);
            this.storage.commitTx();
            this.log.debug(String.format("Got developer %s: %s", developerBean.getId(), developerBean));
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return developerBean;
    }

    private DeveloperBean getDeveloperBeanFromStorage(String id) throws StorageException, DeveloperNotFoundException {
        DeveloperBean developerBean = this.storage.getDeveloper(id);
        if (developerBean == null) {
            throw ExceptionFactory.developerNotFoundException((String)id);
        }
        return developerBean;
    }

    public void delete(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkAdminPermissions();
        try {
            this.storage.beginTx();
            DeveloperBean developerBean = this.getDeveloperBeanFromStorage(id);
            this.storage.deleteDeveloper(developerBean);
            this.storage.commitTx();
            this.log.debug("Deleted developer: " + developerBean.getId());
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public List<ClientVersionSummaryBean> getAllClientVersions(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        List<ClientVersionSummaryBean> clientVersionSummaryBeans;
        this.securityContext.checkIfUserIsCurrentUser(id);
        try {
            this.storage.beginTx();
            DeveloperBean developer = this.getDeveloperBeanFromStorage(id);
            this.storage.commitTx();
            clientVersionSummaryBeans = this.queryMatchingClientVersions(developer);
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return clientVersionSummaryBeans;
    }

    private List<ClientVersionSummaryBean> queryMatchingClientVersions(DeveloperBean developer) throws StorageException {
        ArrayList<ClientVersionSummaryBean> clientVersionSummaryBeans = new ArrayList<ClientVersionSummaryBean>();
        Set developerMappingBeans = developer.getClients();
        for (DeveloperMappingBean bean : developerMappingBeans) {
            List allClientVersionsList = this.query.getClientVersions(bean.getOrganizationId(), bean.getClientId());
            clientVersionSummaryBeans.addAll(allClientVersionsList);
        }
        return clientVersionSummaryBeans;
    }

    public List<ContractSummaryBean> getAllClientContracts(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(id);
        ArrayList<ContractSummaryBean> contractSummaryBeans = new ArrayList<ContractSummaryBean>();
        try {
            this.storage.beginTx();
            DeveloperBean developer = this.getDeveloperBeanFromStorage(id);
            this.storage.commitTx();
            List<ClientVersionSummaryBean> clientVersionSummaryBeans = this.queryMatchingClientVersions(developer);
            for (ClientVersionSummaryBean bean : clientVersionSummaryBeans) {
                List allClientContracts = this.query.getClientContracts(bean.getOrganizationId(), bean.getId(), bean.getVersion());
                contractSummaryBeans.addAll(allClientContracts);
            }
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return contractSummaryBeans;
    }

    public List<ApiVersionBean> getAllApiVersions(String id) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(id);
        ArrayList<ApiVersionBean> apiVersionBeans = new ArrayList<ApiVersionBean>();
        List<ContractSummaryBean> contracts = this.getAllClientContracts(id);
        try {
            this.storage.beginTx();
            for (ContractSummaryBean contract : contracts) {
                ApiVersionBean apiVersion = this.storage.getApiVersion(contract.getApiOrganizationId(), contract.getApiId(), contract.getApiVersion());
                apiVersionBeans.add(apiVersion);
            }
            this.storage.commitTx();
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return apiVersionBeans;
    }

    public Response getPublicApiDefinition(String organizationId, String apiId, String version) {
        this.instantiateOrganizationResource();
        try {
            this.storage.beginTx();
            ApiVersionBean apiVersion = this.organizationResource.getApiVersionFromStorage(organizationId, apiId, version);
            this.storage.commitTx();
            if (apiVersion.isPublicAPI()) {
                return this.organizationResource.getApiDefinition(organizationId, apiId, version);
            }
            throw ExceptionFactory.notAuthorizedException();
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public Response getApiDefinition(String developerId, String organizationId, String apiId, String version) throws DeveloperNotFoundException, NotAuthorizedException {
        this.securityContext.checkIfUserIsCurrentUser(developerId);
        this.instantiateOrganizationResource();
        try {
            this.storage.beginTx();
            Set developerClients = this.getDeveloperBeanFromStorage(developerId).getClients();
            List contracts = this.query.getContracts(organizationId, apiId, version, 1, 10000);
            this.storage.commitTx();
            for (ContractSummaryBean contract : contracts) {
                for (DeveloperMappingBean client : developerClients) {
                    if (!client.getClientId().equals(contract.getClientId()) || !client.getOrganizationId().equals(contract.getClientOrganizationId())) continue;
                    return this.organizationResource.getApiDefinition(organizationId, apiId, version);
                }
            }
        }
        catch (StorageException e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
        return null;
    }

    private void instantiateOrganizationResource() {
        if (this.organizationResource == null) {
            this.organizationResource = new OrganizationResourceImpl();
            this.organizationResource.securityContext = this.securityContext;
            this.organizationResource.storage = this.storage;
            this.organizationResource.query = this.query;
            this.organizationResource.gatewayLinkFactory = this.gatewayLinkFactory;
        }
    }
}

