/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.config.Version;
import io.apiman.manager.api.exportimport.manager.ExportImportManager;
import io.apiman.manager.api.rest.exceptions.mappers.RestExceptionMapper;
import io.apiman.manager.api.rest.impl.ActionResourceImpl;
import io.apiman.manager.api.rest.impl.DeveloperResourceImpl;
import io.apiman.manager.api.rest.impl.DownloadResourceImpl;
import io.apiman.manager.api.rest.impl.GatewayResourceImpl;
import io.apiman.manager.api.rest.impl.OrganizationResourceImpl;
import io.apiman.manager.api.rest.impl.PluginResourceImpl;
import io.apiman.manager.api.rest.impl.PolicyDefinitionResourceImpl;
import io.apiman.manager.api.rest.impl.RoleResourceImpl;
import io.apiman.manager.api.rest.impl.SearchResourceImpl;
import io.apiman.manager.api.rest.impl.SystemResourceImpl;
import io.apiman.manager.api.rest.impl.UserResourceImpl;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;

@ApplicationPath(value="/")
@ApplicationScoped
public class ApiManagerApplication
extends Application {
    @Inject
    ExportImportManager manager;
    private Set<Class<?>> classes = new HashSet();

    public ApiManagerApplication() {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setVersion(new Version().getVersionString());
        beanConfig.setBasePath(this.getBasePath());
        beanConfig.setResourcePackage("io.apiman.manager.api.rest");
        beanConfig.setTitle("API Manager REST API");
        beanConfig.setDescription("The API Manager REST API is used by the API Manager UI to get stuff done. You can use it to automate any API Management task you wish. For example, create new Organizations, Plans, Clients, and APIs.");
        beanConfig.setScan(true);
        this.classes.add(SystemResourceImpl.class);
        this.classes.add(SearchResourceImpl.class);
        this.classes.add(RoleResourceImpl.class);
        this.classes.add(UserResourceImpl.class);
        this.classes.add(OrganizationResourceImpl.class);
        this.classes.add(PolicyDefinitionResourceImpl.class);
        this.classes.add(GatewayResourceImpl.class);
        this.classes.add(PluginResourceImpl.class);
        this.classes.add(ActionResourceImpl.class);
        this.classes.add(DownloadResourceImpl.class);
        this.classes.add(DeveloperResourceImpl.class);
        this.classes.add(ApiListingResource.class);
        this.classes.add(SwaggerSerializers.class);
        this.classes.add(RestExceptionMapper.class);
    }

    @PostConstruct
    protected void postConstruct() {
        if (this.manager.isImportExport()) {
            this.manager.doImportExport();
        }
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    private String getBasePath() {
        String basePath = "/apiman";
        String prefix = System.getenv("SYSTEM_PREFIX");
        return prefix == null ? basePath : prefix.trim().toLowerCase() + basePath;
    }
}

