/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.ApimanLoggerFactory;
import io.apiman.common.logging.IApimanLogger;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.manager.api.beans.actions.ActionBean;
import io.apiman.manager.api.beans.apis.ApiBean;
import io.apiman.manager.api.beans.apis.ApiGatewayBean;
import io.apiman.manager.api.beans.apis.ApiStatus;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.clients.ClientStatus;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.gateways.GatewayBean;
import io.apiman.manager.api.beans.idm.PermissionType;
import io.apiman.manager.api.beans.plans.PlanStatus;
import io.apiman.manager.api.beans.plans.PlanVersionBean;
import io.apiman.manager.api.beans.policies.PolicyBean;
import io.apiman.manager.api.beans.policies.PolicyType;
import io.apiman.manager.api.beans.summary.ContractSummaryBean;
import io.apiman.manager.api.beans.summary.PolicySummaryBean;
import io.apiman.manager.api.core.IApiValidator;
import io.apiman.manager.api.core.IClientValidator;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.gateway.IGatewayLink;
import io.apiman.manager.api.gateway.IGatewayLinkFactory;
import io.apiman.manager.api.rest.IActionResource;
import io.apiman.manager.api.rest.IOrganizationResource;
import io.apiman.manager.api.rest.exceptions.ActionException;
import io.apiman.manager.api.rest.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.exceptions.i18n.Messages;
import io.apiman.manager.api.rest.exceptions.util.ExceptionFactory;
import io.apiman.manager.api.rest.impl.audit.AuditUtils;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class ActionResourceImpl
implements IActionResource {
    private final IApimanLogger log = ApimanLoggerFactory.getLogger(ActionResourceImpl.class);
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    IGatewayLinkFactory gatewayLinkFactory;
    @Inject
    IOrganizationResource orgs;
    @Inject
    IApiValidator apiValidator;
    @Inject
    IClientValidator clientValidator;
    @Inject
    ISecurityContext securityContext;

    public void performAction(ActionBean action) throws ActionException, NotAuthorizedException {
        switch (action.getType()) {
            case publishAPI: {
                this.publishApi(action);
                return;
            }
            case retireAPI: {
                this.retireApi(action);
                return;
            }
            case registerClient: {
                this.registerClient(action);
                return;
            }
            case unregisterClient: {
                this.unregisterClient(action);
                return;
            }
            case lockPlan: {
                this.lockPlan(action);
                return;
            }
        }
        throw ExceptionFactory.actionException((String)("Action type not supported: " + action.getType().toString()));
    }

    private void publishApi(ActionBean action) throws ActionException, NotAuthorizedException {
        ApiVersionBean versionBean;
        this.securityContext.checkPermissions(PermissionType.apiAdmin, action.getOrganizationId());
        try {
            versionBean = this.orgs.getApiVersion(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (ApiVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ApiNotFound", new Object[0]));
        }
        if (!versionBean.isPublicAPI() && versionBean.getStatus() != ApiStatus.Ready) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidApiStatus", new Object[0]));
        }
        if (versionBean.isPublicAPI()) {
            Date publishedOn;
            Date modOn;
            int c;
            if (versionBean.getStatus() == ApiStatus.Retired || versionBean.getStatus() == ApiStatus.Created) {
                throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidApiStatus", new Object[0]));
            }
            if (versionBean.getStatus() == ApiStatus.Published && (c = (modOn = versionBean.getModifiedOn()).compareTo(publishedOn = versionBean.getPublishedOn())) <= 0) {
                throw ExceptionFactory.actionException((String)Messages.i18n.format("ApiRePublishNotRequired", new Object[0]));
            }
        }
        Api gatewayApi = new Api();
        gatewayApi.setEndpoint(versionBean.getEndpoint());
        gatewayApi.setEndpointType(versionBean.getEndpointType().toString());
        if (versionBean.getEndpointContentType() != null) {
            gatewayApi.setEndpointContentType(versionBean.getEndpointContentType().toString());
        }
        gatewayApi.setEndpointProperties(versionBean.getEndpointProperties());
        gatewayApi.setOrganizationId(versionBean.getApi().getOrganization().getId());
        gatewayApi.setApiId(versionBean.getApi().getId());
        gatewayApi.setVersion(versionBean.getVersion());
        gatewayApi.setPublicAPI(versionBean.isPublicAPI());
        gatewayApi.setParsePayload(versionBean.isParsePayload());
        gatewayApi.setKeysStrippingDisabled(versionBean.getDisableKeysStrip());
        boolean hasTx = false;
        try {
            if (versionBean.isPublicAPI()) {
                ArrayList<Policy> policiesToPublish = new ArrayList<Policy>();
                List apiPolicies = this.query.getPolicies(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion(), PolicyType.Api);
                this.storage.beginTx();
                hasTx = true;
                Iterator iterator = apiPolicies.iterator();
                while (iterator.hasNext()) {
                    PolicySummaryBean policySummaryBean = (PolicySummaryBean)iterator.next();
                    PolicyBean apiPolicy = this.storage.getPolicy(PolicyType.Api, action.getOrganizationId(), action.getEntityId(), action.getEntityVersion(), policySummaryBean.getId());
                    Policy policyToPublish = new Policy();
                    policyToPublish.setPolicyJsonConfig(apiPolicy.getConfiguration());
                    policyToPublish.setPolicyImpl(apiPolicy.getDefinition().getPolicyImpl());
                    policiesToPublish.add(policyToPublish);
                }
                gatewayApi.setApiPolicies(policiesToPublish);
            }
        }
        catch (StorageException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PublishError", new Object[0]), (Exception)((Object)e));
        }
        finally {
            if (hasTx) {
                this.storage.rollbackTx();
            }
        }
        try {
            this.storage.beginTx();
            Set gateways = versionBean.getGateways();
            if (gateways == null) {
                throw new PublishingException("No gateways specified for API!");
            }
            for (ApiGatewayBean apiGatewayBean : gateways) {
                IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                gatewayLink.publishApi(gatewayApi);
                gatewayLink.close();
            }
            versionBean.setStatus(ApiStatus.Published);
            versionBean.setPublishedOn(new Date());
            ApiBean api = this.storage.getApi(action.getOrganizationId(), action.getEntityId());
            if (api == null) {
                throw new PublishingException("Error: could not find API - " + action.getOrganizationId() + "=>" + action.getEntityId());
            }
            if (api.getNumPublished() == null) {
                api.setNumPublished(Integer.valueOf(1));
            } else {
                api.setNumPublished(Integer.valueOf(api.getNumPublished() + 1));
            }
            this.storage.updateApi(api);
            this.storage.updateApiVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.apiPublished(versionBean, this.securityContext));
            this.storage.commitTx();
        }
        catch (PublishingException e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PublishError", new Object[0]), (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PublishError", new Object[0]), (Exception)e);
        }
        this.log.debug(String.format("Successfully published API %s on specified gateways: %s", versionBean.getApi().getName(), versionBean.getApi()));
    }

    private IGatewayLink createGatewayLink(String gatewayId) throws PublishingException {
        try {
            GatewayBean gateway = this.storage.getGateway(gatewayId);
            if (gateway == null) {
                throw new GatewayNotFoundException();
            }
            IGatewayLink link = this.gatewayLinkFactory.create(gateway);
            return link;
        }
        catch (GatewayNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PublishingException(e.getMessage(), (Throwable)e);
        }
    }

    private void retireApi(ActionBean action) throws ActionException, NotAuthorizedException {
        ApiVersionBean versionBean;
        this.securityContext.checkPermissions(PermissionType.apiAdmin, action.getOrganizationId());
        try {
            versionBean = this.orgs.getApiVersion(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (ApiVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ApiNotFound", new Object[0]));
        }
        if (versionBean.getStatus() != ApiStatus.Published) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidApiStatus", new Object[0]));
        }
        Api gatewayApi = new Api();
        gatewayApi.setOrganizationId(versionBean.getApi().getOrganization().getId());
        gatewayApi.setApiId(versionBean.getApi().getId());
        gatewayApi.setVersion(versionBean.getVersion());
        try {
            this.storage.beginTx();
            Set gateways = versionBean.getGateways();
            if (gateways == null) {
                throw new PublishingException("No gateways specified for API!");
            }
            for (ApiGatewayBean apiGatewayBean : gateways) {
                IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                gatewayLink.retireApi(gatewayApi);
                gatewayLink.close();
            }
            versionBean.setStatus(ApiStatus.Retired);
            versionBean.setRetiredOn(new Date());
            ApiBean api = this.storage.getApi(action.getOrganizationId(), action.getEntityId());
            if (api == null) {
                throw new PublishingException("Error: could not find API - " + action.getOrganizationId() + "=>" + action.getEntityId());
            }
            if (api.getNumPublished() == null || api.getNumPublished() == 0) {
                api.setNumPublished(Integer.valueOf(0));
            } else {
                api.setNumPublished(Integer.valueOf(api.getNumPublished() - 1));
            }
            this.storage.updateApi(api);
            this.storage.updateApiVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.apiRetired(versionBean, this.securityContext));
            this.storage.commitTx();
        }
        catch (PublishingException e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RetireError", new Object[0]), (Exception)((Object)e));
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RetireError", new Object[0]), (Exception)e);
        }
        this.log.debug(String.format("Successfully retired API %s on specified gateways: %s", versionBean.getApi().getName(), versionBean.getApi()));
    }

    private void registerClient(ActionBean action) throws ActionException, NotAuthorizedException {
        List contractBeans;
        ClientVersionBean versionBean;
        this.securityContext.checkPermissions(PermissionType.clientAdmin, action.getOrganizationId());
        try {
            versionBean = this.orgs.getClientVersion(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (ClientVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("clientVersionDoesNotExist", new Object[]{action.getEntityId(), action.getEntityVersion()}));
        }
        try {
            contractBeans = this.query.getClientContracts(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (StorageException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientNotFound", new Object[0]), (Exception)((Object)e));
        }
        boolean isReregister = false;
        if (versionBean.getStatus() == ClientStatus.Registered) {
            Date publishedOn;
            Date modOn = versionBean.getModifiedOn();
            int c = modOn.compareTo(publishedOn = versionBean.getPublishedOn());
            if (c <= 0) {
                throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientReRegisterNotRequired", new Object[0]));
            }
            isReregister = true;
        }
        Client client = new Client();
        client.setOrganizationId(versionBean.getClient().getOrganization().getId());
        client.setClientId(versionBean.getClient().getId());
        client.setVersion(versionBean.getVersion());
        client.setApiKey(versionBean.getApikey());
        HashSet<Contract> contracts = new HashSet<Contract>();
        for (Object contractBean : contractBeans) {
            Contract contract = new Contract();
            contract.setPlan(contractBean.getPlanId());
            contract.setApiId(contractBean.getApiId());
            contract.setApiOrgId(contractBean.getApiOrganizationId());
            contract.setApiVersion(contractBean.getApiVersion());
            contract.getPolicies().addAll(this.aggregateContractPolicies((ContractSummaryBean)contractBean));
            contracts.add(contract);
        }
        client.setContracts(contracts);
        try {
            this.storage.beginTx();
            HashMap<String, IGatewayLink> links = new HashMap<String, IGatewayLink>();
            for (Contract contract : client.getContracts()) {
                ApiVersionBean svb = this.storage.getApiVersion(contract.getApiOrgId(), contract.getApiId(), contract.getApiVersion());
                Set gateways = svb.getGateways();
                if (gateways == null) {
                    throw new PublishingException("No gateways specified for API: " + svb.getApi().getName());
                }
                for (ApiGatewayBean apiGatewayBean : gateways) {
                    if (links.containsKey(apiGatewayBean.getGatewayId())) continue;
                    IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                    links.put(apiGatewayBean.getGatewayId(), gatewayLink);
                }
            }
            if (isReregister) {
                Iterator gateways = this.storage.getAllGateways();
                while (gateways.hasNext()) {
                    GatewayBean gbean = (GatewayBean)gateways.next();
                    if (links.containsKey(gbean.getId())) continue;
                    IGatewayLink gatewayLink = this.createGatewayLink(gbean.getId());
                    try {
                        gatewayLink.unregisterClient(client);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    gatewayLink.close();
                }
            }
            for (IGatewayLink gatewayLink : links.values()) {
                gatewayLink.registerClient(client);
                gatewayLink.close();
            }
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RegisterError", new Object[0]), (Exception)e);
        }
        versionBean.setStatus(ClientStatus.Registered);
        versionBean.setPublishedOn(new Date());
        try {
            this.storage.beginTx();
            this.storage.updateClientVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.clientRegistered(versionBean, this.securityContext));
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("RegisterError", new Object[0]), (Exception)e);
        }
        this.log.debug(String.format("Successfully registered Client %s on specified gateways: %s", versionBean.getClient().getName(), versionBean.getClient()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Policy> aggregateContractPolicies(ContractSummaryBean contractBean) {
        try {
            PolicyType[] types;
            ArrayList<Policy> policies = new ArrayList<Policy>();
            for (PolicyType policyType : types = new PolicyType[]{PolicyType.Client, PolicyType.Plan, PolicyType.Api}) {
                String ver;
                String id;
                String org;
                switch (policyType) {
                    case Client: {
                        org = contractBean.getClientOrganizationId();
                        id = contractBean.getClientId();
                        ver = contractBean.getClientVersion();
                        break;
                    }
                    case Plan: {
                        org = contractBean.getApiOrganizationId();
                        id = contractBean.getPlanId();
                        ver = contractBean.getPlanVersion();
                        break;
                    }
                    case Api: {
                        org = contractBean.getApiOrganizationId();
                        id = contractBean.getApiId();
                        ver = contractBean.getApiVersion();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Missing case for switch!");
                    }
                }
                List clientPolicies = this.query.getPolicies(org, id, ver, policyType);
                try {
                    this.storage.beginTx();
                    for (PolicySummaryBean policySummaryBean : clientPolicies) {
                        PolicyBean policyBean = this.storage.getPolicy(policyType, org, id, ver, policySummaryBean.getId());
                        Policy policy = new Policy();
                        policy.setPolicyJsonConfig(policyBean.getConfiguration());
                        policy.setPolicyImpl(policyBean.getDefinition().getPolicyImpl());
                        policies.add(policy);
                    }
                }
                finally {
                    this.storage.rollbackTx();
                }
            }
            return policies;
        }
        catch (Exception e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ErrorAggregatingPolicies", new Object[]{contractBean.getClientId() + "->" + contractBean.getApiDescription()}), (Exception)e);
        }
    }

    private void unregisterClient(ActionBean action) throws ActionException, NotAuthorizedException {
        List contractBeans;
        ClientVersionBean versionBean;
        this.securityContext.checkPermissions(PermissionType.clientAdmin, action.getOrganizationId());
        try {
            versionBean = this.orgs.getClientVersion(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (ClientVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientNotFound", new Object[0]));
        }
        try {
            contractBeans = this.query.getClientContracts(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (StorageException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("ClientNotFound", new Object[0]), (Exception)((Object)e));
        }
        if (versionBean.getStatus() != ClientStatus.Registered) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidClientStatus", new Object[0]));
        }
        Client client = new Client();
        client.setOrganizationId(versionBean.getClient().getOrganization().getId());
        client.setClientId(versionBean.getClient().getId());
        client.setVersion(versionBean.getVersion());
        try {
            this.storage.beginTx();
            HashMap<String, IGatewayLink> links = new HashMap<String, IGatewayLink>();
            for (ContractSummaryBean contractBean : contractBeans) {
                ApiVersionBean svb = this.storage.getApiVersion(contractBean.getApiOrganizationId(), contractBean.getApiId(), contractBean.getApiVersion());
                Set gateways = svb.getGateways();
                if (gateways == null) {
                    throw new PublishingException("No gateways specified for API: " + svb.getApi().getName());
                }
                for (ApiGatewayBean apiGatewayBean : gateways) {
                    if (links.containsKey(apiGatewayBean.getGatewayId())) continue;
                    IGatewayLink gatewayLink = this.createGatewayLink(apiGatewayBean.getGatewayId());
                    links.put(apiGatewayBean.getGatewayId(), gatewayLink);
                }
            }
            this.storage.commitTx();
            for (IGatewayLink gatewayLink : links.values()) {
                gatewayLink.unregisterClient(client);
                gatewayLink.close();
            }
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("UnregisterError", new Object[0]), (Exception)e);
        }
        versionBean.setStatus(ClientStatus.Retired);
        versionBean.setRetiredOn(new Date());
        try {
            this.storage.beginTx();
            this.storage.updateClientVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.clientUnregistered(versionBean, this.securityContext));
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("UnregisterError", new Object[0]), (Exception)e);
        }
        this.log.debug(String.format("Successfully registered Client %s on specified gateways: %s", versionBean.getClient().getName(), versionBean.getClient()));
    }

    private void lockPlan(ActionBean action) throws ActionException, NotAuthorizedException {
        PlanVersionBean versionBean;
        this.securityContext.checkPermissions(PermissionType.planAdmin, action.getOrganizationId());
        try {
            versionBean = this.orgs.getPlanVersion(action.getOrganizationId(), action.getEntityId(), action.getEntityVersion());
        }
        catch (PlanVersionNotFoundException e) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("PlanNotFound", new Object[0]));
        }
        if (versionBean.getStatus() == PlanStatus.Locked) {
            throw ExceptionFactory.actionException((String)Messages.i18n.format("InvalidPlanStatus", new Object[0]));
        }
        versionBean.setStatus(PlanStatus.Locked);
        versionBean.setLockedOn(new Date());
        try {
            this.storage.beginTx();
            this.storage.updatePlanVersion(versionBean);
            this.storage.createAuditEntry(AuditUtils.planLocked(versionBean, this.securityContext));
            this.storage.commitTx();
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw ExceptionFactory.actionException((String)Messages.i18n.format("LockError", new Object[0]), (Exception)e);
        }
        this.log.debug(String.format("Successfully locked Plan %s: %s", versionBean.getPlan().getName(), versionBean.getPlan()));
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public IStorageQuery getQuery() {
        return this.query;
    }

    public void setQuery(IStorageQuery query) {
        this.query = query;
    }

    public IApiValidator getApiValidator() {
        return this.apiValidator;
    }

    public void setApiValidator(IApiValidator apiValidator) {
        this.apiValidator = apiValidator;
    }

    public IClientValidator getClientValidator() {
        return this.clientValidator;
    }

    public void setClientValidator(IClientValidator clientValidator) {
        this.clientValidator = clientValidator;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public IOrganizationResource getOrgs() {
        return this.orgs;
    }

    public void setOrgs(IOrganizationResource orgs) {
        this.orgs = orgs;
    }

    public IGatewayLinkFactory getGatewayLinkFactory() {
        return this.gatewayLinkFactory;
    }

    public void setGatewayLinkFactory(IGatewayLinkFactory gatewayLinkFactory) {
        this.gatewayLinkFactory = gatewayLinkFactory;
    }
}

