/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl.util;

import io.apiman.common.plugin.PluginCoordinates;
import io.apiman.manager.api.beans.apis.ApiVersionBean;
import io.apiman.manager.api.beans.clients.ClientVersionBean;
import io.apiman.manager.api.beans.contracts.ContractBean;
import io.apiman.manager.api.beans.summary.PlanVersionSummaryBean;
import io.apiman.manager.api.rest.contract.exceptions.ActionException;
import io.apiman.manager.api.rest.contract.exceptions.ApiAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ApiDefinitionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ApiNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ApiVersionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ApiVersionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ClientAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ClientNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ClientVersionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ClientVersionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.ContractAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.ContractNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.EntityStillActiveException;
import io.apiman.manager.api.rest.contract.exceptions.GatewayAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.GatewayNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidApiStatusException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidClientStatusException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidMetricCriteriaException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidNameException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidPlanStatusException;
import io.apiman.manager.api.rest.contract.exceptions.InvalidVersionException;
import io.apiman.manager.api.rest.contract.exceptions.MemberNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.OrganizationAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.OrganizationNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PlanAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PlanNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PlanVersionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PlanVersionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PluginAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PluginNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PluginResourceNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyDefinitionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyDefinitionInvalidException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyDefinitionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.RoleAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.RoleNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.UserNotFoundException;
import io.apiman.manager.api.rest.impl.i18n.Messages;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class ExceptionFactory {
    private ExceptionFactory() {
    }

    public static final UserNotFoundException userNotFoundException(String username) {
        return new UserNotFoundException(Messages.i18n.format("UserNotFound", new Object[]{username}));
    }

    public static final NotAuthorizedException notAuthorizedException() {
        return new NotAuthorizedException(Messages.i18n.format("AccessDenied", new Object[0]));
    }

    public static final OrganizationAlreadyExistsException organizationAlreadyExistsException(String organizationName) {
        return new OrganizationAlreadyExistsException(Messages.i18n.format("OrganizationAlreadyExists", new Object[]{organizationName}));
    }

    public static final OrganizationNotFoundException organizationNotFoundException(String organizationId) {
        return new OrganizationNotFoundException(Messages.i18n.format("OrganizationDoesNotExist", new Object[]{organizationId}));
    }

    public static final RoleAlreadyExistsException roleAlreadyExistsException(String roleId) {
        return new RoleAlreadyExistsException(Messages.i18n.format("RoleAlreadyExists", new Object[]{roleId}));
    }

    public static final RoleNotFoundException roleNotFoundException(String roleId) {
        return new RoleNotFoundException(Messages.i18n.format("RoleNotFound", new Object[]{roleId}));
    }

    public static final ClientAlreadyExistsException clientAlreadyExistsException(String clientName) {
        return new ClientAlreadyExistsException(Messages.i18n.format("ClientAlreadyExists", new Object[]{clientName}));
    }

    public static final ClientVersionAlreadyExistsException clientVersionAlreadyExistsException(String clientName, String version) {
        return new ClientVersionAlreadyExistsException(Messages.i18n.format("clientVersionAlreadyExists", new Object[]{clientName, version}));
    }

    public static final ContractAlreadyExistsException contractAlreadyExistsException() {
        return new ContractAlreadyExistsException(Messages.i18n.format("ContractAlreadyExists", new Object[0]));
    }

    public static final ClientNotFoundException clientNotFoundException(String clientId) {
        return new ClientNotFoundException(Messages.i18n.format("ClientDoesNotExist", new Object[]{clientId}));
    }

    public static final ContractNotFoundException contractNotFoundException(Long contractId) {
        return new ContractNotFoundException(Messages.i18n.format("ContractDoesNotExist", new Object[]{contractId}));
    }

    public static final ClientVersionNotFoundException clientVersionNotFoundException(String clientId, String version) {
        return new ClientVersionNotFoundException(Messages.i18n.format("clientVersionDoesNotExist", new Object[]{clientId, version}));
    }

    public static final InvalidClientStatusException invalidClientStatusException() {
        return new InvalidClientStatusException(Messages.i18n.format("InvalidClientStatus", new Object[0]));
    }

    public static final ApiAlreadyExistsException apiAlreadyExistsException(String apiName) {
        return new ApiAlreadyExistsException(Messages.i18n.format("ApiAlreadyExists", new Object[]{apiName}));
    }

    public static final ApiVersionAlreadyExistsException apiVersionAlreadyExistsException(String apiName, String version) {
        return new ApiVersionAlreadyExistsException(Messages.i18n.format("ApiVersionAlreadyExists", new Object[]{apiName, version}));
    }

    public static final ApiNotFoundException apiNotFoundException(String apiId) {
        return new ApiNotFoundException(Messages.i18n.format("ApiDoesNotExist", new Object[]{apiId}));
    }

    public static final ApiVersionNotFoundException apiVersionNotFoundException(String apiId, String version) {
        return new ApiVersionNotFoundException(Messages.i18n.format("ApiVersionDoesNotExist", new Object[]{apiId, version}));
    }

    public static final ApiDefinitionNotFoundException apiDefinitionNotFoundException(String apiId, String version) {
        return new ApiDefinitionNotFoundException(Messages.i18n.format("ApiDefinitionDoesNotExist", new Object[]{apiId, version}));
    }

    public static final InvalidApiStatusException invalidApiStatusException() {
        return new InvalidApiStatusException(Messages.i18n.format("InvalidApiStatus", new Object[0]));
    }

    public static final InvalidPlanStatusException invalidPlanStatusException() {
        return new InvalidPlanStatusException(Messages.i18n.format("InvalidPlanStatus", new Object[0]));
    }

    public static InvalidPlanStatusException invalidPlanStatusException(List<PlanVersionSummaryBean> lockedPlans) {
        return new InvalidPlanStatusException(Messages.i18n.format("InvalidPlanStatus", new Object[0]) + " " + ExceptionFactory.joinList(lockedPlans));
    }

    public static final MemberNotFoundException memberNotFoundException(String memberId) {
        return new MemberNotFoundException(Messages.i18n.format("MemberDoesNotExist", new Object[]{memberId}));
    }

    public static final PlanAlreadyExistsException planAlreadyExistsException(String planName) {
        return new PlanAlreadyExistsException(Messages.i18n.format("PlanAlreadyExists", new Object[]{planName}));
    }

    public static final PlanVersionAlreadyExistsException planVersionAlreadyExistsException(String planName, String version) {
        return new PlanVersionAlreadyExistsException(Messages.i18n.format("PlanVersionAlreadyExists", new Object[]{planName, version}));
    }

    public static final PlanNotFoundException planNotFoundException(String planId) {
        return new PlanNotFoundException(Messages.i18n.format("PlanDoesNotExist", new Object[]{planId}));
    }

    public static final PlanVersionNotFoundException planVersionNotFoundException(String planId, String version) {
        return new PlanVersionNotFoundException(Messages.i18n.format("PlanVersionDoesNotExist", new Object[]{planId, version}));
    }

    public static final ActionException actionException(String message) {
        return new ActionException(message);
    }

    public static ActionException actionException(String message, Exception cause) {
        return new ActionException(message, (Throwable)cause);
    }

    public static final PolicyNotFoundException policyNotFoundException(long policyId) {
        return new PolicyNotFoundException(Messages.i18n.format("PolicyDoesNotExist", new Object[]{policyId}));
    }

    public static final PolicyDefinitionAlreadyExistsException policyDefAlreadyExistsException(String policyDefName) {
        return new PolicyDefinitionAlreadyExistsException(Messages.i18n.format("PolicyDefinitionAlreadyExists", new Object[]{policyDefName}));
    }

    public static final PolicyDefinitionNotFoundException policyDefNotFoundException(String policyDefId) {
        return new PolicyDefinitionNotFoundException(Messages.i18n.format("PolicyDefinitionDoesNotExist", new Object[]{policyDefId}));
    }

    public static final PolicyDefinitionInvalidException policyDefInvalidException(String message) {
        return new PolicyDefinitionInvalidException(message);
    }

    public static final GatewayAlreadyExistsException gatewayAlreadyExistsException(String gatewayName) {
        return new GatewayAlreadyExistsException(Messages.i18n.format("GatewayAlreadyExists", new Object[]{gatewayName}));
    }

    public static final GatewayNotFoundException gatewayNotFoundException(String gatewayId) {
        return new GatewayNotFoundException(Messages.i18n.format("GatewayDoesNotExist", new Object[]{gatewayId}));
    }

    public static final PluginAlreadyExistsException pluginAlreadyExistsException() {
        return new PluginAlreadyExistsException(Messages.i18n.format("PluginAlreadyExists", new Object[0]));
    }

    public static final PluginNotFoundException pluginNotFoundException(Long pluginId) {
        return new PluginNotFoundException(Messages.i18n.format("PluginDoesNotExist", new Object[]{pluginId}));
    }

    public static final PluginResourceNotFoundException pluginResourceNotFoundException(String resourceName, PluginCoordinates coordinates) {
        return new PluginResourceNotFoundException(Messages.i18n.format("PluginResourceNotFound", new Object[]{resourceName, coordinates.toString()}));
    }

    public static final InvalidMetricCriteriaException invalidMetricCriteriaException(String message) {
        return new InvalidMetricCriteriaException(message);
    }

    public static final InvalidNameException invalidNameException(String message) {
        return new InvalidNameException(message);
    }

    public static final InvalidVersionException invalidVersionException(String message) {
        return new InvalidVersionException(message);
    }

    public static EntityStillActiveException entityStillActiveExceptionContracts(List<ContractBean> contracts) {
        return new EntityStillActiveException(Messages.i18n.format("EntityStillActiveContracts", new Object[]{ExceptionFactory.joinList(contracts)}));
    }

    public static EntityStillActiveException entityStillActiveExceptionClientVersions(List<ClientVersionBean> clientApps) {
        return new EntityStillActiveException(Messages.i18n.format("EntityStillActiveClientApps", new Object[]{ExceptionFactory.joinList(clientApps)}));
    }

    public static EntityStillActiveException entityStillActiveExceptionApiVersions(List<ApiVersionBean> apis) {
        return new EntityStillActiveException(Messages.i18n.format("EntityStillActiveApis", new Object[]{ExceptionFactory.joinList(apis)}));
    }

    public static EntityStillActiveException entityStillActiveExceptionContracts(Iterator<ContractBean> contracts) {
        return new EntityStillActiveException(Messages.i18n.format("EntityStillActiveContracts", new Object[]{ExceptionFactory.joinIter(contracts)}));
    }

    public static EntityStillActiveException entityStillActiveExceptionClientVersions(Iterator<ClientVersionBean> clientApps) {
        return new EntityStillActiveException(Messages.i18n.format("EntityStillActiveClientApps", new Object[]{ExceptionFactory.joinIter(clientApps)}));
    }

    public static EntityStillActiveException entityStillActiveExceptionApiVersions(Iterator<ApiVersionBean> apis) {
        return new EntityStillActiveException(Messages.i18n.format("EntityStillActiveApis", new Object[]{ExceptionFactory.joinIter(apis)}));
    }

    private static <T> String joinList(List<T> items) {
        return items.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    private static <T> String joinIter(Iterator<T> iter) {
        Iterable iterable = () -> iter;
        return StreamSupport.stream(iterable.spliterator(), false).map(Object::toString).collect(Collectors.joining(", "));
    }
}

