/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.common.logging.IApimanLogger;
import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.beans.download.DownloadType;
import io.apiman.manager.api.beans.system.SystemStatusBean;
import io.apiman.manager.api.config.Version;
import io.apiman.manager.api.core.IDownloadManager;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.core.logging.ApimanLogger;
import io.apiman.manager.api.exportimport.json.JsonExportWriter;
import io.apiman.manager.api.exportimport.json.JsonImportReader;
import io.apiman.manager.api.exportimport.manager.StorageExporter;
import io.apiman.manager.api.exportimport.manager.StorageImportDispatcher;
import io.apiman.manager.api.exportimport.read.IImportReader;
import io.apiman.manager.api.exportimport.read.IImportReaderDispatcher;
import io.apiman.manager.api.exportimport.write.IExportWriter;
import io.apiman.manager.api.migrator.DataMigrator;
import io.apiman.manager.api.rest.contract.ISystemResource;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.BooleanUtils;

@ApplicationScoped
public class SystemResourceImpl
implements ISystemResource {
    @Inject
    private IStorage storage;
    @Inject
    private ISecurityContext securityContext;
    @Inject
    private Version version;
    @Inject
    @ApimanLogger(value=IImportReader.class)
    private IApimanLogger importLogger;
    @Inject
    @ApimanLogger(value=IExportWriter.class)
    private IApimanLogger exportLogger;
    @Inject
    private StorageExporter exporter;
    @Inject
    private StorageImportDispatcher importer;
    @Inject
    private DataMigrator migrator;
    @Inject
    private IDownloadManager downloadManager;
    @Context
    private HttpServletRequest request;

    public SystemStatusBean getStatus() {
        SystemStatusBean rval = new SystemStatusBean();
        rval.setId("apiman-manager-api");
        rval.setName("API Manager REST API");
        rval.setDescription("The API Manager REST API is used by the API Manager UI to get stuff done.  You can use it to automate any apiman task you wish.  For example, create new Organizations, Plans, Clients, and APIs.");
        rval.setMoreInfo("http://www.apiman.io/latest/api-manager-restdocs.html");
        rval.setUp(this.getStorage() != null);
        if (this.getVersion() != null) {
            rval.setVersion(this.getVersion().getVersionString());
            rval.setBuiltOn(this.getVersion().getVersionDate());
        }
        return rval;
    }

    public Response exportData(String download) {
        if (BooleanUtils.toBoolean((String)download)) {
            try {
                DownloadBean dbean = this.downloadManager.createDownload(DownloadType.exportJson, "/system/export");
                return Response.ok((Object)dbean, (String)"application/json").build();
            }
            catch (StorageException e) {
                throw new SystemErrorException((Throwable)e);
            }
        }
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        return this.exportData();
    }

    public Response exportData() {
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream os) throws IOException, WebApplicationException {
                JsonExportWriter writer = new JsonExportWriter(os, SystemResourceImpl.this.exportLogger);
                SystemResourceImpl.this.getExporter().init((IExportWriter)writer);
                SystemResourceImpl.this.getExporter().export();
                os.flush();
            }
        };
        return Response.ok((Object)stream, (String)"application/json").header("Content-Disposition", (Object)"attachment; filename=api-manager-export.json").build();
    }

    public Response importData() {
        File tempFile;
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            tempFile = File.createTempFile("apiman_import", ".json");
            tempFile.deleteOnExit();
            ServletInputStream data = this.request.getInputStream();
            FileUtils.copyInputStreamToFile((InputStream)data, (File)tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final File importFile = tempFile;
        StreamingOutput stream = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                JsonImportReader reader;
                final PrintWriter writer = new PrintWriter(output);
                IApimanLogger logger = new IApimanLogger(){

                    public void warn(String message) {
                        writer.println("WARN: " + message);
                        writer.flush();
                    }

                    public void trace(String message) {
                        writer.println("TRACE: " + message);
                        writer.flush();
                    }

                    public void info(String message) {
                        writer.println("INFO: " + message);
                        writer.flush();
                    }

                    public void error(String message, Throwable error) {
                        writer.println("ERROR: " + message);
                        error.printStackTrace(writer);
                        writer.flush();
                    }

                    public void error(Throwable error) {
                        writer.println("ERROR: " + error.getMessage());
                        error.printStackTrace(writer);
                        writer.flush();
                    }

                    public void debug(String message) {
                        writer.println("DEBUG: " + message);
                        writer.flush();
                    }
                };
                File migratedImportFile = File.createTempFile("apiman_import_migrated", ".json");
                migratedImportFile.deleteOnExit();
                SystemResourceImpl.this.migrator.setLogger(logger);
                SystemResourceImpl.this.migrator.migrate(importFile, migratedImportFile);
                FileInputStream importData = null;
                try {
                    importData = new FileInputStream(migratedImportFile);
                    reader = new JsonImportReader(logger, (InputStream)importData);
                }
                catch (IOException e) {
                    IOUtils.closeQuietly(importData);
                    throw new SystemErrorException((Throwable)e);
                }
                try {
                    SystemResourceImpl.this.importer.setLogger(logger);
                    SystemResourceImpl.this.importer.start();
                    reader.setDispatcher((IImportReaderDispatcher)SystemResourceImpl.this.importer);
                    reader.read();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)importData);
                    FileUtils.deleteQuietly((File)importFile);
                    FileUtils.deleteQuietly((File)migratedImportFile);
                }
            }
        };
        return Response.ok((Object)stream).build();
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public StorageExporter getExporter() {
        return this.exporter;
    }

    public void setExporter(StorageExporter exporter) {
        this.exporter = exporter;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

