/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.BeanUtils;
import io.apiman.manager.api.beans.policies.PolicyDefinitionBean;
import io.apiman.manager.api.beans.policies.UpdatePolicyDefinitionBean;
import io.apiman.manager.api.beans.summary.PolicyDefinitionSummaryBean;
import io.apiman.manager.api.beans.summary.PolicyFormType;
import io.apiman.manager.api.core.IStorage;
import io.apiman.manager.api.core.IStorageQuery;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.contract.IPolicyDefinitionResource;
import io.apiman.manager.api.rest.contract.exceptions.AbstractRestException;
import io.apiman.manager.api.rest.contract.exceptions.NotAuthorizedException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyDefinitionAlreadyExistsException;
import io.apiman.manager.api.rest.contract.exceptions.PolicyDefinitionNotFoundException;
import io.apiman.manager.api.rest.contract.exceptions.SystemErrorException;
import io.apiman.manager.api.rest.impl.i18n.Messages;
import io.apiman.manager.api.rest.impl.util.ExceptionFactory;
import io.apiman.manager.api.security.ISecurityContext;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class PolicyDefinitionResourceImpl
implements IPolicyDefinitionResource {
    @Inject
    IStorage storage;
    @Inject
    IStorageQuery query;
    @Inject
    ISecurityContext securityContext;

    public List<PolicyDefinitionSummaryBean> list() throws NotAuthorizedException {
        try {
            return this.query.listPolicyDefinitions();
        }
        catch (StorageException e) {
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyDefinitionBean create(PolicyDefinitionBean bean) throws PolicyDefinitionAlreadyExistsException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        if (bean.getId() == null || bean.getId().trim().isEmpty()) {
            bean.setId(BeanUtils.idFromName((String)bean.getName()));
        } else {
            bean.setId(BeanUtils.idFromName((String)bean.getId()));
        }
        try {
            this.storage.beginTx();
            if (this.storage.getPolicyDefinition(bean.getId()) != null) {
                throw ExceptionFactory.policyDefAlreadyExistsException(bean.getName());
            }
            if (bean.getFormType() == null) {
                bean.setFormType(PolicyFormType.Default);
            }
            this.storage.createPolicyDefinition(bean);
            this.storage.commitTx();
            return bean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public PolicyDefinitionBean get(String policyDefinitionId) throws PolicyDefinitionNotFoundException, NotAuthorizedException {
        try {
            this.storage.beginTx();
            PolicyDefinitionBean bean = this.storage.getPolicyDefinition(policyDefinitionId);
            if (bean == null) {
                throw ExceptionFactory.policyDefNotFoundException(policyDefinitionId);
            }
            this.storage.commitTx();
            return bean;
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void update(String policyDefinitionId, UpdatePolicyDefinitionBean bean) throws PolicyDefinitionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            PolicyDefinitionBean pdb = this.storage.getPolicyDefinition(policyDefinitionId);
            if (pdb == null) {
                throw ExceptionFactory.policyDefNotFoundException(policyDefinitionId);
            }
            if (pdb.getPluginId() != null) {
                throw new SystemErrorException(Messages.i18n.format("CannotUpdatePluginPolicyDef", new Object[0]));
            }
            if (bean.getName() != null) {
                pdb.setName(bean.getName());
            }
            if (bean.getDescription() != null) {
                pdb.setDescription(bean.getDescription());
            }
            if (bean.getIcon() != null) {
                pdb.setIcon(bean.getIcon());
            }
            this.storage.updatePolicyDefinition(pdb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public void delete(String policyDefinitionId) throws PolicyDefinitionNotFoundException, NotAuthorizedException {
        if (!this.securityContext.isAdmin()) {
            throw ExceptionFactory.notAuthorizedException();
        }
        try {
            this.storage.beginTx();
            PolicyDefinitionBean pdb = this.storage.getPolicyDefinition(policyDefinitionId);
            if (pdb == null) {
                throw ExceptionFactory.policyDefNotFoundException(policyDefinitionId);
            }
            if (pdb.getPluginId() != null) {
                throw new SystemErrorException(Messages.i18n.format("CannotDeletePluginPolicyDef", new Object[0]));
            }
            this.storage.deletePolicyDefinition(pdb);
            this.storage.commitTx();
        }
        catch (AbstractRestException e) {
            this.storage.rollbackTx();
            throw e;
        }
        catch (Exception e) {
            this.storage.rollbackTx();
            throw new SystemErrorException((Throwable)e);
        }
    }

    public IStorage getStorage() {
        return this.storage;
    }

    public void setStorage(IStorage storage) {
        this.storage = storage;
    }

    public ISecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(ISecurityContext securityContext) {
        this.securityContext = securityContext;
    }
}

