/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.manager.api.rest.impl;

import io.apiman.manager.api.beans.download.DownloadBean;
import io.apiman.manager.api.core.IDownloadManager;
import io.apiman.manager.api.core.exceptions.StorageException;
import io.apiman.manager.api.rest.contract.IDownloadResource;
import io.apiman.manager.api.rest.contract.IOrganizationResource;
import io.apiman.manager.api.rest.contract.ISystemResource;
import io.apiman.manager.api.rest.contract.exceptions.DownloadNotFoundException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@ApplicationScoped
public class DownloadResourceImpl
implements IDownloadResource {
    @Inject
    private IDownloadManager downloadManager;
    @Inject
    private ISystemResource system;
    @Inject
    private IOrganizationResource orgs;
    @Context
    private HttpServletRequest request;

    public Response download(String downloadId) throws DownloadNotFoundException {
        DownloadBean download;
        try {
            download = this.downloadManager.getDownload(downloadId);
            if (download == null) {
                throw new DownloadNotFoundException();
            }
        }
        catch (StorageException e) {
            throw new DownloadNotFoundException((Throwable)e);
        }
        String path = download.getPath();
        switch (download.getType()) {
            case apiRegistryJson: {
                ApiRegistryInfo info = this.parseApiRegistryPath(path);
                return this.orgs.getApiRegistryJSON(info.organizationId, info.clientId, info.version, info.hasPermission);
            }
            case apiRegistryXml: {
                ApiRegistryInfo info = this.parseApiRegistryPath(path);
                return this.orgs.getApiRegistryXML(info.organizationId, info.clientId, info.version, info.hasPermission);
            }
            case exportJson: {
                return this.system.exportData();
            }
        }
        throw new DownloadNotFoundException();
    }

    private ApiRegistryInfo parseApiRegistryPath(String path) {
        String[] split = path.split("/");
        ApiRegistryInfo info = new ApiRegistryInfo();
        info.organizationId = split[0];
        info.clientId = split[1];
        info.version = split[2];
        info.hasPermission = "+".equals(split[3]);
        return info;
    }

    public IDownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    public void setDownloadManager(IDownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    private static class ApiRegistryInfo {
        public String organizationId;
        public String clientId;
        public String version;
        public boolean hasPermission;

        private ApiRegistryInfo() {
        }
    }
}

