/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.implementations.pipeline;

import io.annot8.api.components.responses.SourceResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.ItemFactory;
import io.annot8.api.pipelines.Pipeline;
import io.annot8.api.pipelines.PipelineDescriptor;
import io.annot8.api.pipelines.PipelineRunner;
import io.annot8.common.components.logging.Logging;
import io.annot8.implementations.pipeline.SimplePipeline;
import io.annot8.implementations.support.stores.QueueItemFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryPipelineRunner
implements PipelineRunner {
    private final Pipeline pipeline;
    private final Logger logger;
    private final QueueItemFactory itemFactory;
    private boolean running = true;

    public InMemoryPipelineRunner(Pipeline pipeline, ItemFactory itemFactory) {
        this.pipeline = pipeline;
        this.logger = pipeline.getContext().getResource(Logging.class).map(l -> l.getLogger(InMemoryPipelineRunner.class)).orElse(LoggerFactory.getLogger(InMemoryPipelineRunner.class));
        this.itemFactory = new QueueItemFactory(itemFactory);
        this.itemFactory.register(i -> this.logger.debug("Item {} added to queue", (Object)i.getId()));
    }

    public InMemoryPipelineRunner(PipelineDescriptor pipelineDescriptor, ItemFactory itemFactory) {
        this(new SimplePipeline.Builder().from(pipelineDescriptor).build(), itemFactory);
    }

    public InMemoryPipelineRunner(PipelineDescriptor pipelineDescriptor, ItemFactory itemFactory, Context context) {
        this(new SimplePipeline.Builder().from(pipelineDescriptor).withContext(context).build(), itemFactory);
    }

    public void run() {
        this.logger.info("Pipeline {} started", (Object)this.pipeline.getName());
        this.running = true;
        while (this.running) {
            SourceResponse sr = this.pipeline.read((ItemFactory)this.itemFactory);
            while (this.running && !this.itemFactory.isEmpty()) {
                this.itemFactory.next().ifPresent(arg_0 -> ((Pipeline)this.pipeline).process(arg_0));
            }
            if (sr.getStatus() != SourceResponse.Status.DONE) continue;
            this.stop();
        }
    }

    public void stop() {
        this.logger.info("Stopping pipeline after current item/source");
        this.running = false;
    }
}

