/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.wordnet.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.context.Context;
import io.annot8.api.exceptions.Annot8RuntimeException;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import java.util.Optional;
import net.sf.extjwnl.JWNLException;
import net.sf.extjwnl.data.IndexWord;
import net.sf.extjwnl.data.POS;
import net.sf.extjwnl.dictionary.Dictionary;

@ComponentName(value="WordNet Lemmas")
@ComponentDescription(value="Add lemmas to word tokens using WordNet")
public class WordNet
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings noSettings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withProcessesAnnotations("grammar/wordToken", SpanBounds.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private Dictionary dictionary;

        public Processor() {
            try {
                this.dictionary = Dictionary.getDefaultResourceInstance();
            }
            catch (IllegalArgumentException | JWNLException e) {
                throw new Annot8RuntimeException("Could not load WordNet dictionary", e);
            }
        }

        protected void process(Text content) {
            content.getAnnotations().getByBoundsAndType(SpanBounds.class, "grammar/wordToken").filter(a -> a.getProperties().has("pos", String.class)).forEach(a -> {
                Optional<IndexWord> lookupWord;
                POS pos = Processor.toPos((String)a.getProperties().get("pos", String.class).get());
                String word = (String)content.getText(a).get();
                if (pos != null && (lookupWord = this.lookupWord(pos, word)).isPresent()) {
                    ((Annotation.Builder)content.getAnnotations().copy(a).withProperty("lemma", (Object)lookupWord.get().getLemma())).save();
                    content.getAnnotations().delete(a);
                }
            });
        }

        public void close() {
            try {
                this.dictionary.close();
            }
            catch (JWNLException e) {
                this.log().warn("WordNet dictionary did not close cleanly", (Throwable)e);
            }
            finally {
                this.dictionary = null;
            }
        }

        public static POS toPos(String pos) {
            String lc = pos.toUpperCase();
            POS ret = null;
            if (lc.startsWith("N")) {
                ret = POS.NOUN;
            } else if (lc.startsWith("V")) {
                ret = POS.VERB;
            } else if (lc.startsWith("R") || lc.startsWith("ADV")) {
                ret = POS.ADVERB;
            } else if (lc.startsWith("J") || lc.startsWith("ADJ")) {
                ret = POS.ADJECTIVE;
            }
            return ret;
        }

        public Optional<IndexWord> lookupWord(POS pos, String word) {
            try {
                return Optional.ofNullable(this.dictionary.lookupIndexWord(pos, word));
            }
            catch (JWNLException e) {
                this.log().warn("Lookup word {} failed", (Object)word, (Object)e);
                return Optional.empty();
            }
        }
    }
}

