/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.translation.processors;

import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.settings.Description;
import io.annot8.api.settings.Settings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import uk.gov.dstl.machinetranslation.connector.api.MTConnectorApi;

public class MachineTranslationSettings
implements Settings {
    private String sourceLanguage = "auto";
    private String targetLanguage = null;
    private Class<? extends MTConnectorApi> translatorClass = null;
    private Map<String, Object> translatorConfiguration = new HashMap<String, Object>();
    private boolean copyProperties = false;

    public boolean validate() {
        return this.targetLanguage != null && this.translatorClass != null;
    }

    @Description(value="Source language to translate from, or auto", defaultValue="auto")
    public String getSourceLanguage() {
        if (this.sourceLanguage == null) {
            return "auto";
        }
        return this.sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    @Description(value="Target language to translate to")
    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    @Description(value="MTConnectorApi Connector Class")
    public Class<? extends MTConnectorApi> getTranslatorClass() {
        return this.translatorClass;
    }

    public void setTranslatorClass(Class<? extends MTConnectorApi> translatorClass) {
        this.translatorClass = translatorClass;
    }

    public void setTranslatorClass(String translatorClass) throws BadConfigurationException {
        Class<?> clazz;
        try {
            clazz = Class.forName(translatorClass);
        }
        catch (ClassNotFoundException e) {
            this.translatorClass = null;
            throw new BadConfigurationException("Could not find class " + translatorClass, (Throwable)e);
        }
        if (!MTConnectorApi.class.isAssignableFrom(clazz)) {
            this.translatorClass = null;
            throw new BadConfigurationException("Translator Class must implement MTConnectorApi");
        }
        this.translatorClass = clazz;
    }

    @Description(value="Configuration for Connector API")
    public Map<String, Object> getTranslatorConfiguration() {
        if (this.translatorConfiguration == null) {
            return Collections.emptyMap();
        }
        return this.translatorConfiguration;
    }

    public void setTranslatorConfiguration(Map<String, Object> translatorConfiguration) {
        this.translatorConfiguration = translatorConfiguration;
    }

    public void setTranslatorConfiguration(String key, Object value) {
        if (this.translatorConfiguration == null) {
            this.translatorConfiguration = new HashMap<String, Object>();
        }
        this.translatorConfiguration.put(key, value);
    }

    @Description(value="Should properties be copied from source Content?", defaultValue="false")
    public boolean isCopyProperties() {
        return this.copyProperties;
    }

    public void setCopyProperties(boolean copyProperties) {
        this.copyProperties = copyProperties;
    }
}

