/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.translation.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.api.exceptions.ProcessingException;
import io.annot8.api.properties.Properties;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.components.translation.processors.MachineTranslationSettings;
import java.util.Collection;
import uk.gov.dstl.machinetranslation.connector.api.LanguagePair;
import uk.gov.dstl.machinetranslation.connector.api.MTConnectorApi;
import uk.gov.dstl.machinetranslation.connector.api.Translation;
import uk.gov.dstl.machinetranslation.connector.api.exceptions.ConfigurationException;
import uk.gov.dstl.machinetranslation.connector.api.exceptions.ConnectorException;

@ComponentName(value="Machine Translation")
@ComponentDescription(value="Uses the Machine Translation API to translate text between languages")
@SettingsClass(value=MachineTranslationSettings.class)
@ComponentTags(value={"translation", "text"})
public class MachineTranslation
extends AbstractProcessorDescriptor<Processor, MachineTranslationSettings> {
    protected Processor createComponent(Context context, MachineTranslationSettings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Text.class).withCreatesContent(Text.class).build();
    }

    public static class Processor
    extends AbstractTextProcessor {
        private final MTConnectorApi connector;
        private final String sourceLanguage;
        private final String targetLanguage;
        private final boolean copyProperties;

        protected Processor(String sourceLanguage, String targetLanguage, boolean copyProperties, MTConnectorApi connector) {
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = targetLanguage;
            this.copyProperties = copyProperties;
            this.connector = connector;
        }

        public Processor(MachineTranslationSettings settings) {
            this.sourceLanguage = settings.getSourceLanguage();
            this.targetLanguage = settings.getTargetLanguage();
            this.copyProperties = settings.isCopyProperties();
            try {
                this.connector = settings.getTranslatorClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BadConfigurationException("Could not instantiate MT Connector", (Throwable)e);
            }
            try {
                this.connector.configure(settings.getTranslatorConfiguration());
            }
            catch (ConfigurationException e) {
                throw new BadConfigurationException("Could not configure MT Connector", (Throwable)e);
            }
            if (!"auto".equals(this.sourceLanguage) && this.connector.queryEngine().isSupportedLanguagesSupported()) {
                try {
                    Collection supportedLanguages = this.connector.supportedLanguages();
                    if (!supportedLanguages.contains(new LanguagePair(this.sourceLanguage, this.targetLanguage))) {
                        throw new BadConfigurationException("Unsupported language pair (" + this.sourceLanguage + " -> " + this.targetLanguage + ")");
                    }
                }
                catch (ConnectorException connectorException) {
                    // empty catch block
                }
            }
        }

        protected void process(Text content) {
            Translation translatedText;
            try {
                translatedText = this.connector.translate(this.sourceLanguage, this.targetLanguage, (String)content.getData());
            }
            catch (ConnectorException e) {
                throw new ProcessingException("Unable to translate text", (Throwable)e);
            }
            Content.Builder builder = content.getItem().createContent(Text.class).withDescription("Translated " + content.getId() + " from " + translatedText.getSourceLanguage() + " to " + this.targetLanguage + " by " + this.connector.queryEngine().getName()).withData((Object)translatedText.getContent());
            if (this.copyProperties) {
                builder = (Content.Builder)builder.withProperties((Properties)content.getProperties());
            }
            ((Content.Builder)builder.withProperty("language", (Object)this.targetLanguage)).save();
        }
    }
}

