/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.text.processors.settings;

import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import com.optimaize.langdetect.text.CommonTextObjectFactories;
import com.optimaize.langdetect.text.TextObjectFactory;
import io.annot8.core.settings.Settings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class DetectLanguageSettings
implements Settings {
    private Optional<List<LanguageProfile>> languageProfiles = Optional.empty();
    private Optional<NgramExtractor> ngramExtractor = Optional.empty();
    private Optional<TextObjectFactory> textObjectFactory = Optional.empty();

    public boolean validate() {
        return true;
    }

    public List<LanguageProfile> getLanguageProfiles() {
        if (this.languageProfiles.isPresent()) {
            return this.languageProfiles.get();
        }
        try {
            return new LanguageProfileReader().readAllBuiltIn();
        }
        catch (IOException ioe) {
            return Collections.emptyList();
        }
    }

    public void setLanguageProfiles(List<LanguageProfile> languageProfiles) {
        this.languageProfiles = Optional.of(languageProfiles);
    }

    public NgramExtractor getNgramExtractor() {
        return this.ngramExtractor.orElse(NgramExtractors.standard());
    }

    public void setNgramExtractor(NgramExtractor ngramExtractor) {
        this.ngramExtractor = Optional.of(ngramExtractor);
    }

    public TextObjectFactory getTextObjectFactory() {
        return this.textObjectFactory.orElse(CommonTextObjectFactories.forDetectingOnLargeText());
    }

    public void setTextObjectFactory(TextObjectFactory textObjectFactory) {
        this.textObjectFactory = Optional.of(textObjectFactory);
    }
}

