/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.stopwords.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import io.annot8.common.data.content.Text;
import io.annot8.components.stopwords.processors.StopwordsProcessor;
import io.annot8.components.stopwords.resources.CollectionStopwords;
import io.annot8.components.stopwords.resources.StopwordsIso;
import java.util.List;
import java.util.Set;

@ComponentName(value="Remove Collection Stopwords")
@ComponentDescription(value="Remove annotations that appear on a user provided stopwords list")
@ComponentTags(value={"annotations", "stopwords"})
@SettingsClass(value=Settings.class)
public class RemoveCollectionStopwords
extends AbstractProcessorDescriptor<StopwordsProcessor, Settings> {
    protected StopwordsProcessor createComponent(Context context, Settings settings) {
        return new StopwordsProcessor(new CollectionStopwords(settings.getLanguage(), settings.getStopwords()), settings.getTypes());
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder b = new SimpleCapabilities.Builder().withProcessesContent(Text.class);
        if (((Settings)this.getSettings()).getTypes() == null || ((Settings)this.getSettings()).getTypes().isEmpty()) {
            b = b.withDeletesAnnotations("*", SpanBounds.class);
        } else {
            for (String type : ((Settings)this.getSettings()).getTypes()) {
                b = b.withDeletesAnnotations(type, SpanBounds.class);
            }
        }
        return b.build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String language = "en";
        private Set<String> stopwords = Set.of();
        private List<String> types = List.of();

        public boolean validate() {
            return StopwordsIso.SUPPORTED_LANGUAGES.contains(this.language);
        }

        @Description(value="The language of the ISO Stopwords dictionary to use", defaultValue="en")
        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        @Description(value="List of types to check - if null or empty, then all types are checked")
        public List<String> getTypes() {
            return this.types;
        }

        public void setTypes(List<String> types) {
            this.types = types;
        }

        @Description(value="Stopwords to remove")
        public Set<String> getStopwords() {
            return this.stopwords;
        }

        public void setStopwords(Set<String> stopwords) {
            this.stopwords = stopwords;
        }
    }
}

