/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;

@ComponentName(value="Rename Item Property")
@ComponentDescription(value="Renames a property on an Item")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties"})
public class RenameItemProperty
extends AbstractProcessorDescriptor<Processor, Settings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    public Processor createComponent(Context context, Settings settings) {
        return new Processor(settings.getExistingKey(), settings.getNewKey());
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String existingKey;
        private String newKey;

        public Settings() {
        }

        @JsonbCreator
        public Settings(@JsonbProperty(value="existingKey") String existingKey, @JsonbProperty(value="newKey") String newKey) {
            this.existingKey = existingKey;
            this.newKey = newKey;
        }

        public boolean validate() {
            return this.existingKey != null;
        }

        @Description(value="The key of the property to be renamed")
        public String getExistingKey() {
            return this.existingKey;
        }

        public void setExistingKey(String existingKey) {
            this.existingKey = existingKey;
        }

        @Description(value="The new name for the property")
        public String getNewKey() {
            return this.newKey;
        }

        public void setNewKey(String newKey) {
            this.newKey = newKey;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final String existingKey;
        private final String newKey;

        public Processor(String existingKey, String newKey) {
            this.existingKey = existingKey;
            this.newKey = newKey;
        }

        public ProcessorResponse process(Item item) {
            if (this.existingKey == null || this.existingKey.isEmpty()) {
                return ProcessorResponse.processingError();
            }
            if (this.newKey != null && !this.newKey.isEmpty()) {
                item.getProperties().get(this.existingKey).ifPresent(o -> item.getProperties().set(this.newKey, o));
            }
            item.getProperties().remove(this.existingKey);
            return ProcessorResponse.ok();
        }
    }
}

