/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.NoSettings;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import java.util.List;
import java.util.stream.Collectors;

@ComponentName(value="Remove Empty Properties")
@ComponentDescription(value="Remove Item Properties that are empty or blank")
@ComponentTags(value={"item", "properties"})
public class RemoveEmptyProperties
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public static class Processor
    extends AbstractProcessor {
        public ProcessorResponse process(Item item) {
            List emptyKeys = item.getProperties().keys().filter(key -> {
                String s;
                Object o = item.getProperties().get(key).orElse(null);
                if (o == null) {
                    return true;
                }
                return o instanceof String && (s = (String)o).isBlank();
            }).collect(Collectors.toList());
            item.getProperties().remove(emptyKeys);
            return ProcessorResponse.ok();
        }
    }
}

