/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.items.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;

@ComponentName(value="Item Property as String")
@ComponentDescription(value="Converts an existing Item Property into a String")
@SettingsClass(value=Settings.class)
@ComponentTags(value={"item", "properties", "string"})
public class ItemPropertyAsString
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().build();
    }

    public static class Settings
    implements io.annot8.api.settings.Settings {
        private String key = "key";

        public boolean validate() {
            return this.key != null;
        }

        @Description(value="The property key to convert")
        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            if (item.getProperties().has(this.settings.getKey())) {
                Object o = item.getProperties().get(this.settings.getKey()).get();
                item.getProperties().set(this.settings.getKey(), (Object)o.toString());
            }
            return ProcessorResponse.ok();
        }
    }
}

