/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.grouping.processors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.annot8.api.annotations.Annotation;
import io.annot8.api.annotations.Group;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.NoSettings;
import io.annot8.api.stores.GroupStore;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.SpanBounds;
import java.util.Objects;
import java.util.Optional;

@ComponentName(value="Group by Type and Value")
@ComponentDescription(value="Group annotations within a Content where their type and value are the same")
public class GroupByTypeAndValue
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesAnnotations("*", SpanBounds.class).withCreatesGroups("exactMatches").build();
    }

    public static class Processor
    extends AbstractProcessor {
        public static final String TYPE = "exactMatches";
        private static final String ROLE = "as";

        public ProcessorResponse process(Item item) {
            item.getContents().forEach(this::process);
            return ProcessorResponse.ok();
        }

        protected <D> void process(Content<D> content) {
            HashMultimap map = HashMultimap.create();
            content.getAnnotations().getByBounds(SpanBounds.class).forEach(arg_0 -> this.lambda$process$1(content, (SetMultimap)map, arg_0));
            GroupStore groupStore = content.getItem().getGroups();
            map.asMap().values().stream().filter(annotations -> annotations.size() > 1).forEach(annotations -> {
                Group.Builder builder = (Group.Builder)groupStore.create().withType(TYPE);
                annotations.forEach(a -> builder.withAnnotation(ROLE, a));
                builder.save();
            });
        }

        private /* synthetic */ void lambda$process$1(Content content, SetMultimap map, Annotation a) {
            Optional optional = a.getBounds().getData(content);
            optional.ifPresent(covered -> map.put((Object)new TypeObjectPair(a.getType(), covered), (Object)a));
        }

        private class TypeObjectPair {
            private final String type;
            private final Object object;

            public TypeObjectPair(String type, Object object) {
                this.type = type;
                this.object = object;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TypeObjectPair that = (TypeObjectPair)o;
                return Objects.equals(this.type, that.type) && Objects.equals(this.object, that.object);
            }

            public int hashCode() {
                return Objects.hash(this.type, this.object);
            }
        }
    }
}

