/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.grouping.processors;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import io.annot8.common.data.content.Text;
import io.annot8.components.base.processors.AbstractTextProcessor;
import io.annot8.core.annotations.Annotation;
import io.annot8.core.annotations.Group;
import io.annot8.core.capabilities.CreatesGroup;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.stores.GroupStore;
import java.util.Optional;

@CreatesGroup(value="exactMatches")
public class GroupByTypeAndValueAnnotator
extends AbstractTextProcessor {
    public static final String TYPE = "exactMatches";
    private static final String ROLE = "as";

    protected void process(Item item, Text content) {
        HashMultimap map = HashMultimap.create();
        content.getAnnotations().getAll().forEach(arg_0 -> this.lambda$process$1(content, (SetMultimap)map, arg_0));
        GroupStore groupStore = item.getGroups();
        map.asMap().values().forEach(annotations -> {
            Group.Builder builder = (Group.Builder)groupStore.create().withType(TYPE);
            annotations.forEach(a -> builder.withAnnotation(ROLE, a));
            try {
                builder.save();
            }
            catch (IncompleteException e) {
                this.log().info("Unable to save group", (Throwable)e);
            }
        });
    }

    private String toKey(String type, String covered) {
        return type + ":" + covered;
    }

    private /* synthetic */ void lambda$process$1(Text content, SetMultimap map, Annotation a) {
        Optional optional = content.getText(a);
        optional.ifPresent(covered -> {
            String key = this.toKey(a.getType(), (String)covered);
            map.put((Object)key, (Object)a);
        });
    }
}

