/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.IncompleteException;
import io.annot8.api.settings.NoSettings;
import io.annot8.api.stores.AnnotationStore;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.bounds.NoBounds;
import io.annot8.common.data.content.FileContent;
import io.annot8.conventions.PathUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;

@ComponentName(value="File Metadata Extractor")
@ComponentDescription(value="Extract metadata from files")
public class FileMetadataExtractor
extends AbstractProcessorDescriptor<Processor, NoSettings> {
    protected Processor createComponent(Context context, NoSettings settings) {
        return new Processor();
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).build();
    }

    public static class Processor
    extends AbstractProcessor {
        public static final String FILE_METADATA = PathUtils.join((String[])new String[]{"file", "metadata"});

        public ProcessorResponse process(Item item) {
            boolean withoutErrors = item.getContents(FileContent.class).map(this::extractMetadata).reduce(true, (a, b) -> a != false && b != false);
            if (!withoutErrors) {
                return ProcessorResponse.itemError();
            }
            return ProcessorResponse.ok();
        }

        private boolean extractMetadata(FileContent fileContent) {
            BasicFileAttributes attr;
            String owner;
            boolean isSym;
            boolean isDir;
            boolean isRegular;
            boolean isHidden;
            File file = (File)fileContent.getData();
            if (!file.exists()) {
                return false;
            }
            try {
                isHidden = Files.isHidden(file.toPath());
                isRegular = Files.isRegularFile(file.toPath(), new LinkOption[0]);
                isDir = Files.isDirectory(file.toPath(), new LinkOption[0]);
                isSym = Files.isSymbolicLink(file.toPath());
                owner = Files.getOwner(file.toPath(), new LinkOption[0]).getName();
            }
            catch (IOException e) {
                this.log().error("Failed to retrieve file metadata", (Throwable)e);
                return false;
            }
            try {
                attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                this.log().error("Failed to process file attributes", (Throwable)e);
                return false;
            }
            if (attr != null) {
                this.createMetadataAnnotation(fileContent, "createdDate", attr.creationTime().toMillis());
                this.createMetadataAnnotation(fileContent, "lastModifiedDate", attr.lastModifiedTime().toMillis());
                this.createMetadataAnnotation(fileContent, "lastAccessDate", attr.lastAccessTime().toMillis());
                this.createMetadataAnnotation(fileContent, "fileSize", attr.size());
            }
            this.createMetadataAnnotation(fileContent, "path", file.getAbsolutePath());
            this.createMetadataAnnotation(fileContent, "hidden", isHidden);
            this.createMetadataAnnotation(fileContent, "regular", isRegular);
            this.createMetadataAnnotation(fileContent, "directory", isDir);
            this.createMetadataAnnotation(fileContent, "symlink", isSym);
            this.createMetadataAnnotation(fileContent, "owner", owner);
            this.createMetadataAnnotation(fileContent, "filename", file.getName());
            String extension = this.getFileExtension(file);
            if (extension != null) {
                this.createMetadataAnnotation(fileContent, "extension", extension);
            }
            return true;
        }

        private String getFileExtension(File file) {
            String name = file.getName();
            int index = name.lastIndexOf(46);
            if (index > 0 && index != name.length()) {
                return name.substring(index + 1);
            }
            return null;
        }

        private void createMetadataAnnotation(FileContent content, String key, Object value) {
            AnnotationStore annotations = content.getAnnotations();
            try {
                ((Annotation.Builder)((Annotation.Builder)annotations.create().withType(FILE_METADATA)).withBounds((Bounds)NoBounds.getInstance()).withProperty(key, value)).save();
            }
            catch (IncompleteException e) {
                this.log().error("Failed to create file metadata annotation", (Throwable)e);
            }
        }
    }
}

