/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.processors;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import com.j256.simplemagic.ContentType;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.InputStreamContent;
import io.annot8.components.files.processors.RemoveSourceContentSettings;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorStreamFactory;

@ComponentName(value="Archive Extractor")
@ComponentDescription(value="Extract archive files (*.zip, *.tar.gz, etc.) and create new items from each file")
@SettingsClass(value=Settings.class)
public class ArchiveExtractor
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        SimpleCapabilities.Builder builder = new SimpleCapabilities.Builder().withProcessesContent(FileContent.class).withProcessesContent(InputStreamContent.class);
        if (((Settings)this.getSettings()).isRemoveSourceContent()) {
            builder = builder.withDeletesContent(FileContent.class);
        }
        return builder.build();
    }

    public static class Settings
    extends RemoveSourceContentSettings {
        private boolean discardItem = false;
        private List<ContentType> contentTypes = List.of(ContentType.ZIP, ContentType.GZIP, ContentType.TAR);
        private boolean acceptNullContentType = true;

        @Description(value="If true, this entire Item will be discarded after successful extraction")
        public boolean isDiscardItem() {
            return this.discardItem;
        }

        public void setDiscardItem(boolean discardItem) {
            this.discardItem = discardItem;
        }

        @Description(value="List of content types to allow - if the detected content type is not on this list, then it will not be treated as an archive. An empty list will cause the processor to try to parse all Files and InputStreams.")
        public List<ContentType> getContentTypes() {
            return this.contentTypes;
        }

        public void setContentTypes(List<ContentType> contentTypes) {
            this.contentTypes = contentTypes;
        }

        @Description(value="Determines whether the processor should try to parse Files and InputStreams where the content type cannot be determined")
        public boolean isAcceptNullContentType() {
            return this.acceptNullContentType;
        }

        public void setAcceptNullContentType(boolean acceptNullContentType) {
            this.acceptNullContentType = acceptNullContentType;
        }
    }

    public static class Processor
    extends AbstractProcessor {
        private final ArchiveStreamFactory archiveStreamFactory = new ArchiveStreamFactory();
        private final CompressorStreamFactory compressorStreamFactory = new CompressorStreamFactory();
        private final ContentInfoUtil util = new ContentInfoUtil();
        private final Settings settings;

        public Processor(Settings settings) {
            this.settings = settings;
        }

        public ProcessorResponse process(Item item) {
            ArrayList exceptions = new ArrayList();
            item.getContents(FileContent.class).filter(fc -> {
                try {
                    if (this.settings.getContentTypes().isEmpty()) {
                        return true;
                    }
                    ContentInfo ci = this.util.findMatch((File)fc.getData());
                    if (ci == null) {
                        return this.settings.isAcceptNullContentType();
                    }
                    return this.settings.getContentTypes().contains(ci.getContentType());
                }
                catch (IOException e) {
                    this.log().warn("Unable to perform content type detection on File {}", (Object)((File)fc.getData()).getName(), (Object)e);
                    return this.settings.isAcceptNullContentType();
                }
            }).forEach(fc -> {
                boolean extracted;
                try (BufferedInputStream is = new BufferedInputStream(new FileInputStream((File)fc.getData()));){
                    extracted = this.decompress(item, is, ((File)fc.getData()).getPath());
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                    this.log().error("Unable to read archive file", (Throwable)ioe);
                    return;
                }
                if (extracted && this.settings.isRemoveSourceContent()) {
                    item.removeContent((Content)fc);
                }
            });
            item.getContents(InputStreamContent.class).filter(isc -> {
                if (this.settings.getContentTypes().isEmpty()) {
                    return true;
                }
                try {
                    ContentInfo ci = this.util.findMatch((InputStream)isc.getData());
                    if (ci == null) {
                        return this.settings.isAcceptNullContentType();
                    }
                    return this.settings.getContentTypes().contains(ci.getContentType());
                }
                catch (IOException e) {
                    this.log().warn("Unable to perform content type detection on InputStream {}", (Object)isc.getId(), (Object)e);
                    return this.settings.isAcceptNullContentType();
                }
            }).forEach(isc -> {
                boolean extracted;
                try (BufferedInputStream is = new BufferedInputStream((InputStream)isc.getData());){
                    extracted = this.decompress(item, is, null);
                }
                catch (IOException ioe) {
                    exceptions.add(ioe);
                    this.log().error("Unable to read archive file", (Throwable)ioe);
                    return;
                }
                if (extracted && this.settings.isRemoveSourceContent()) {
                    item.removeContent((Content)isc);
                }
            });
            if (exceptions.isEmpty()) {
                if (this.settings.isDiscardItem()) {
                    item.discard();
                }
                return ProcessorResponse.ok();
            }
            return ProcessorResponse.itemError(exceptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean decompress(Item item, InputStream inputStream, String source) throws IOException {
            InputStream is;
            block21: {
                try {
                    block22: {
                        is = new BufferedInputStream((InputStream)this.compressorStreamFactory.createCompressorInputStream(inputStream));
                        is.mark(-1);
                        if (this.settings.getContentTypes().isEmpty()) break block21;
                        try {
                            ContentInfo ci = this.util.findMatch(is);
                            if (ci == null ? !this.settings.isAcceptNullContentType() : !this.settings.getContentTypes().contains(ci.getContentType())) {
                                return false;
                            }
                        }
                        catch (IOException e) {
                            this.log().warn("Unable to perform content type detection on uncompressed InputStream", (Throwable)e);
                            if (this.settings.isAcceptNullContentType()) break block22;
                            return false;
                        }
                    }
                    is.reset();
                }
                catch (CompressorException ce) {
                    this.log().debug("No suitable compressor found, or stream is not compressed", (Throwable)ce);
                    is = inputStream;
                }
            }
            try (ArchiveInputStream ais = this.archiveStreamFactory.createArchiveInputStream(is);){
                if (ais == null) {
                    boolean bl = false;
                    return bl;
                }
                ArchiveEntry archiveEntry = null;
                while ((archiveEntry = ais.getNextEntry()) != null) {
                    int len;
                    if (archiveEntry.isDirectory()) continue;
                    Item childItem = item.createChild();
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.put("source", source);
                    props.put("name", archiveEntry.getName());
                    props.put("lastModifiedDate", this.toLocalDateTime(archiveEntry.getLastModifiedDate()));
                    props.put("size", archiveEntry.getSize());
                    props.values().removeIf(Objects::isNull);
                    childItem.getProperties().set(props);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buffer = new byte[1024];
                    while ((len = ais.read(buffer)) > 0) {
                        baos.write(buffer, 0, len);
                    }
                    baos.flush();
                    childItem.createContent(InputStreamContent.class).withData(() -> new ByteArrayInputStream(baos.toByteArray())).withDescription("Content extracted from archive").save();
                }
            }
            catch (ArchiveException e) {
                this.log().debug("No suitable archiver found, or stream is not archived", (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                is.close();
            }
            return true;
        }

        private LocalDateTime toLocalDateTime(Date date) {
            if (date == null) {
                return null;
            }
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
    }
}

