/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.content;

import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import io.annot8.api.exceptions.ProcessingException;
import io.annot8.common.data.content.ColumnMetadata;
import io.annot8.common.data.content.DefaultRow;
import io.annot8.common.data.content.Row;
import io.annot8.common.data.content.Table;
import io.annot8.common.data.content.TableMetadata;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class CSVTable
implements Table {
    private final TableMetadata metadata;
    private final List<Row> rows = new ArrayList<Row>();

    public CSVTable(File file, boolean hasHeaders) {
        CsvReader reader;
        try {
            reader = CsvReader.builder().build(file.toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to read CSV file", (Throwable)e);
        }
        int index = hasHeaders ? -1 : 0;
        int maxCols = 0;
        List<String> headers = Collections.emptyList();
        for (CsvRow csvRow : reader) {
            if (index < 0) {
                headers = csvRow.getFields().stream().map(String::strip).collect(Collectors.toList());
            } else {
                this.rows.add((Row)new DefaultRow(index, CSVTable.getHeaders(headers, csvRow.getFieldCount()), new ArrayList(csvRow.getFields())));
            }
            maxCols = Math.max(maxCols, csvRow.getFieldCount());
            ++index;
        }
        this.metadata = new TableMetadata(file.getName(), "CSV", this.toColumnMetadata(CSVTable.getHeaders(headers, maxCols)), index);
    }

    public static List<String> getHeaders(List<String> knownHeaders, int colCount) {
        if (colCount == knownHeaders.size()) {
            return knownHeaders;
        }
        if (colCount < knownHeaders.size()) {
            return knownHeaders.subList(0, colCount);
        }
        return Stream.concat(knownHeaders.stream(), IntStream.range(knownHeaders.size(), colCount).mapToObj(i -> "Column " + (i + 1))).collect(Collectors.toList());
    }

    public int getColumnCount() {
        return this.metadata.getColumns().size();
    }

    public int getRowCount() {
        return this.metadata.getRowCount();
    }

    public Optional<List<String>> getColumnNames() {
        List names = this.metadata.getColumns().stream().map(ColumnMetadata::getName).collect(Collectors.toList());
        return Optional.ofNullable(names);
    }

    public Stream<Row> getRows() {
        return this.rows.stream();
    }

    private List<ColumnMetadata> toColumnMetadata(Collection<String> columnNames) {
        return columnNames.stream().map(s -> new ColumnMetadata(s, 0L)).collect(Collectors.toList());
    }
}

