/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.files.sources;

import io.annot8.api.settings.Description;
import io.annot8.api.settings.Settings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.json.bind.annotation.JsonbCreator;

public class FileSystemSourceSettings
implements Settings {
    private Path rootFolder = Paths.get(".", new String[0]);
    private boolean watching = true;
    private boolean recursive = true;
    private boolean reprocessOnModify = true;
    private Set<Pattern> acceptedFileNamePatterns = new HashSet<Pattern>();

    @JsonbCreator
    public FileSystemSourceSettings() {
    }

    public FileSystemSourceSettings(Path rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Description(value="Root folder to read from")
    public Path getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(Path rootFolder) {
        this.rootFolder = rootFolder;
    }

    @Description(value="Should the folder be read recursively")
    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }

    @Description(value="Should files be reprocessed if they are modified")
    public boolean isReprocessOnModify() {
        return this.reprocessOnModify;
    }

    public void setReprocessOnModify(boolean reprocessOnModify) {
        this.reprocessOnModify = reprocessOnModify;
    }

    @Description(value="Accepted file name patterns")
    public Set<Pattern> getAcceptedFileNamePatterns() {
        return this.acceptedFileNamePatterns;
    }

    public void setAcceptedFileNamePatterns(Set<Pattern> acceptedFileNamePatterns) {
        this.acceptedFileNamePatterns = acceptedFileNamePatterns;
    }

    public void addAcceptedFilePattern(Pattern acceptedFilePattern) {
        this.acceptedFileNamePatterns.add(acceptedFilePattern);
    }

    @Description(value="Should the folder be watched for changes (true), or just scanned once (false)")
    public boolean isWatching() {
        return this.watching;
    }

    public void setWatching(boolean watching) {
        this.watching = watching;
    }

    public boolean validate() {
        return this.rootFolder != null;
    }
}

