/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.elasticsearch.processors;

import io.annot8.api.bounds.Bounds;
import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.api.settings.Description;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.components.elasticsearch.ElasticsearchSettings;
import io.annot8.components.elasticsearch.ElasticsearchUtils;
import io.annot8.components.elasticsearch.processors.AbstractElasticsearchSink;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.xcontent.XContentType;

@ComponentName(value="Elasticsearch Sink - Nested")
@ComponentDescription(value="Persists processed items into Elasticsearch, using a nested structure")
@ComponentTags(value={"elasticsearch"})
@SettingsClass(value=Settings.class)
public class NestedElasticsearchSink
extends AbstractProcessorDescriptor<Processor, Settings> {
    protected Processor createComponent(Context context, Settings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Content.class).withProcessesAnnotations("*", Bounds.class).withProcessesGroups("*").build();
    }

    public static class Settings
    extends ElasticsearchSettings {
        private boolean useNested = false;

        @Description(value="Should the 'nested' type be used for arrays within Elasticsearch?", defaultValue="false")
        public boolean isUseNested() {
            return this.useNested;
        }

        public void setUseNested(boolean useNested) {
            this.useNested = useNested;
        }
    }

    public static class Processor
    extends AbstractElasticsearchSink {
        public static final String ANNOTATIONS = "annotations";
        public static final String CONTENTS = "contents";
        public static final String GROUPS = "groups";

        public Processor(Settings settings) {
            super(settings);
            try {
                if (this.client.indices().exists(new GetIndexRequest(new String[]{this.index}), RequestOptions.DEFAULT)) {
                    this.log().warn("Index {} already exists - mapping will not be applied", (Object)this.index);
                } else {
                    this.log().info("Creating index {}", (Object)this.index);
                    CreateIndexResponse createResponse = this.client.indices().create(new CreateIndexRequest(this.index), RequestOptions.DEFAULT);
                    if (!createResponse.isAcknowledged()) {
                        this.log().warn("Server did not acknowledge creation index {}", (Object)this.index);
                    }
                    this.log().info("Creating mapping for index {}", (Object)this.index);
                    Object file = settings.isUseNested() ? "nesNestedMapping" : "nesMapping";
                    file = (String)file + (settings.isForceString() ? "String.json" : ".json");
                    String mapping = new BufferedReader(new InputStreamReader(NestedElasticsearchSink.class.getResourceAsStream((String)file))).lines().collect(Collectors.joining("\n"));
                    AcknowledgedResponse mappingResponse = this.client.indices().putMapping(new PutMappingRequest(new String[]{this.index}).source(mapping, XContentType.JSON), RequestOptions.DEFAULT);
                    if (!mappingResponse.isAcknowledged()) {
                        this.log().warn("Server did not acknowledge creation of mapping for index {}", (Object)this.index);
                    }
                }
            }
            catch (IOException e) {
                this.log().error("An exception occurred whilst creating a mapping for index {}", (Object)this.index, (Object)e);
            }
        }

        @Override
        protected List<IndexRequest> itemToIndexRequests(Item item) {
            IndexRequest ir = new IndexRequest(this.index).source(Processor.transformItem(item, this.forceString)).id(item.getId());
            return List.of(ir);
        }

        protected static Map<String, Object> transformItem(Item item, boolean forceString) {
            Map<String, Object> m = ElasticsearchUtils.itemToMap(item, forceString);
            ArrayList contents = new ArrayList();
            item.getContents().forEach(c -> {
                Map<String, Object> mc = ElasticsearchUtils.contentToMap(c, forceString);
                ArrayList annotations = new ArrayList();
                c.getAnnotations().getAll().map(a -> ElasticsearchUtils.annotationToMap(a, c, forceString)).forEach(annotations::add);
                mc.put(ANNOTATIONS, annotations);
                contents.add(mc);
            });
            m.put(CONTENTS, contents);
            ArrayList groups = new ArrayList();
            item.getGroups().getAll().map(g -> ElasticsearchUtils.groupToMap(g, forceString)).forEach(groups::add);
            m.put(GROUPS, groups);
            return m;
        }
    }
}

