/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.elasticsearch.processors;

import io.annot8.api.capabilities.Capabilities;
import io.annot8.api.components.annotations.ComponentDescription;
import io.annot8.api.components.annotations.ComponentName;
import io.annot8.api.components.annotations.ComponentTags;
import io.annot8.api.components.annotations.SettingsClass;
import io.annot8.api.context.Context;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.common.components.AbstractProcessorDescriptor;
import io.annot8.common.components.capabilities.SimpleCapabilities;
import io.annot8.components.elasticsearch.ElasticsearchSettings;
import io.annot8.components.elasticsearch.ElasticsearchUtils;
import io.annot8.components.elasticsearch.processors.AbstractElasticsearchSink;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.action.index.IndexRequest;

@ComponentName(value="Elasticsearch Sink - Content")
@ComponentDescription(value="Persists content into Elasticsearch")
@ComponentTags(value={"content", "elasticsearch"})
@SettingsClass(value=ElasticsearchSettings.class)
public class ContentElasticsearchSink
extends AbstractProcessorDescriptor<Processor, ElasticsearchSettings> {
    protected Processor createComponent(Context context, ElasticsearchSettings settings) {
        return new Processor(settings);
    }

    public Capabilities capabilities() {
        return new SimpleCapabilities.Builder().withProcessesContent(Content.class).build();
    }

    public static class Processor
    extends AbstractElasticsearchSink {
        public Processor(ElasticsearchSettings settings) {
            super(settings);
        }

        @Override
        protected List<IndexRequest> itemToIndexRequests(Item item) {
            ArrayList<IndexRequest> indexRequests = new ArrayList<IndexRequest>();
            item.getContents().map(c -> {
                Map<String, Object> m = ElasticsearchUtils.contentToMap(c, this.forceString);
                m.put("itemId", c.getItem().getId());
                return new IndexRequest(this.index).id(c.getId()).source(m);
            }).forEach(indexRequests::add);
            return indexRequests;
        }

        @Override
        protected Optional<Map<String, Object>> getMapping() {
            Map<String, Object> m = ElasticsearchUtils.contentMapping();
            m.put("itemId", ElasticsearchUtils.mappingType("keyword"));
            return Optional.of(ElasticsearchUtils.wrapWithProperties(m));
        }
    }
}

