/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.elasticsearch.processors;

import io.annot8.api.components.responses.ProcessorResponse;
import io.annot8.api.data.Item;
import io.annot8.api.exceptions.BadConfigurationException;
import io.annot8.common.components.AbstractProcessor;
import io.annot8.components.elasticsearch.ElasticsearchSettings;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpHost;
import org.apache.http.client.CredentialsProvider;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetIndexRequest;

public abstract class AbstractElasticsearchSink
extends AbstractProcessor {
    protected final RestHighLevelClient client;
    protected final String index;
    protected final boolean forceString;

    public AbstractElasticsearchSink(ElasticsearchSettings settings) {
        this(List.of(settings.host()), settings.getIndex(), settings.isDeleteIndex(), settings.isForceString(), settings.credentials());
    }

    public AbstractElasticsearchSink(List<HttpHost> hosts, String index, boolean deleteIndex, boolean forceString, CredentialsProvider credentials) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts.toArray(new HttpHost[0]));
        if (credentials != null) {
            builder.setHttpClientConfigCallback(httpClientBuilder -> httpClientBuilder.setDefaultCredentialsProvider(credentials));
        }
        this.client = new RestHighLevelClient(builder);
        this.index = index;
        this.forceString = forceString;
        try {
            if (!this.client.ping(RequestOptions.DEFAULT)) {
                throw new BadConfigurationException("Could not connect to Elasticsearch - ping returned false");
            }
        }
        catch (IOException e) {
            throw new BadConfigurationException("Could not connect to Elasticsearch", (Throwable)e);
        }
        try {
            if (deleteIndex && this.client.indices().exists(new GetIndexRequest(new String[]{index}), RequestOptions.DEFAULT)) {
                this.log().info("Deleting index {}", (Object)index);
                this.client.indices().delete(new DeleteIndexRequest(index), RequestOptions.DEFAULT);
            }
        }
        catch (IOException e) {
            this.log().error("An exception occurred whilst deleting index {}", (Object)index, (Object)e);
        }
        try {
            if (this.client.indices().exists(new GetIndexRequest(new String[]{index}), RequestOptions.DEFAULT)) {
                this.log().warn("Index {} already exists - existing mapping will be used", (Object)index);
            } else {
                Optional<Map<String, Object>> mapping = this.getMapping();
                if (mapping.isPresent()) {
                    this.log().info("Creating index {} with mapping", (Object)index);
                    this.client.indices().create(new CreateIndexRequest(index).mapping(mapping.get()), RequestOptions.DEFAULT);
                }
            }
        }
        catch (IOException e) {
            this.log().error("An exception occurred whilst creating index {}", (Object)index, (Object)e);
        }
    }

    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (IOException e) {
                this.log().warn("Unable to close Elasticsearch client", (Throwable)e);
            }
        }
    }

    public ProcessorResponse process(Item item) {
        List<IndexRequest> requests;
        try {
            requests = this.itemToIndexRequests(item);
        }
        catch (Exception e) {
            this.log().error("Unable to serialize item {}: {}", (Object)item.getId(), (Object)e.getMessage());
            return ProcessorResponse.itemError((Exception[])new Exception[]{e});
        }
        if (requests.isEmpty()) {
            this.log().debug("No index requests created for item {}", (Object)item.getId());
            return ProcessorResponse.ok();
        }
        BulkRequest bulkRequest = new BulkRequest();
        requests.forEach(arg_0 -> ((BulkRequest)bulkRequest).add(arg_0));
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        try {
            this.log().debug("Performing bulk request to index item {} ({} index requests)", (Object)item.getId(), (Object)requests.size());
            BulkResponse response = this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
            for (BulkItemResponse bulkItemResponse : response) {
                if (bulkItemResponse.isFailed()) {
                    BulkItemResponse.Failure failure = bulkItemResponse.getFailure();
                    this.log().error("Failed to create/update document {} in index {}: {}", new Object[]{bulkItemResponse.getId(), bulkItemResponse.getIndex(), failure.getMessage(), failure.getCause()});
                    exceptions.add(failure.getCause());
                    continue;
                }
                DocWriteResponse itemResponse = bulkItemResponse.getResponse();
                if (itemResponse.getResult() == DocWriteResponse.Result.CREATED) {
                    this.log().debug("New document {} created in index {}", (Object)itemResponse.getId(), (Object)itemResponse.getIndex());
                    continue;
                }
                if (itemResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                    this.log().debug("Existing document {} updated in index {}", (Object)itemResponse.getId(), (Object)itemResponse.getIndex());
                    continue;
                }
                this.log().error("Unexpected result returned whilst indexing document {} in index {}: {}", new Object[]{itemResponse.getId(), itemResponse.getIndex(), itemResponse.getResult().name()});
            }
        }
        catch (ConnectException e) {
            this.log().error("Unable to connect to Elasticsearch whilst performing bulk request: {}", (Object)e.getMessage());
            return ProcessorResponse.processingError((Exception[])new Exception[]{e});
        }
        catch (IOException e) {
            this.log().error("Exception thrown whilst performing bulk request: {}", (Object)e.getMessage());
            return ProcessorResponse.itemError((Exception[])new Exception[]{e});
        }
        if (exceptions.isEmpty()) {
            return ProcessorResponse.ok();
        }
        return ProcessorResponse.itemError(exceptions);
    }

    protected Optional<Map<String, Object>> getMapping() {
        return Optional.empty();
    }

    protected abstract List<IndexRequest> itemToIndexRequests(Item var1);
}

