/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.elasticsearch;

import io.annot8.api.annotations.Annotation;
import io.annot8.api.annotations.Group;
import io.annot8.api.data.Content;
import io.annot8.api.data.Item;
import io.annot8.common.data.bounds.SpanBounds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;

public class ElasticsearchUtils {
    public static final String ANNOTATION_ID = "annotationId";
    public static final String BEGIN = "begin";
    public static final String BOUNDS_TYPE = "boundsType";
    public static final String CONTENT = "content";
    public static final String CONTENT_ID = "contentId";
    public static final String CONTENT_TYPE = "contentType";
    public static final String DESCRIPTION = "description";
    public static final String END = "end";
    public static final String GEO = "geo";
    public static final String ID = "id";
    public static final String ITEM_ID = "itemId";
    public static final String PARENT = "parent";
    public static final String PROPERTIES = "properties";
    public static final String ROLES = "roles";
    public static final String TYPE = "type";
    public static final String VALUE = "value";

    private ElasticsearchUtils() {
    }

    public static Map<String, Object> annotationToMap(Annotation a, Content<?> c, boolean forceString) {
        HashMap<String, Object> ma = new HashMap<String, Object>();
        ma.put(ID, a.getId());
        ma.put(TYPE, a.getType());
        ma.put(BOUNDS_TYPE, a.getBounds().getClass().getName());
        Map<String, Object> annotationProps = a.getProperties().getAll();
        if (!annotationProps.isEmpty()) {
            ma.put(PROPERTIES, forceString ? ElasticsearchUtils.toStringMap(annotationProps) : annotationProps);
        }
        boolean geoJsonSucceeded = false;
        if (a.getProperties().has("geojson", String.class)) {
            try {
                XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (String)a.getProperties().get("geojson", String.class).get());
                ma.put(GEO, parser.map());
                geoJsonSucceeded = true;
            }
            catch (Exception parser) {
                // empty catch block
            }
        }
        if (!geoJsonSucceeded && a.getProperties().has("latitude", Number.class) && a.getProperties().has("longitude", Number.class)) {
            double lat = ((Number)a.getProperties().get("latitude", Number.class).get()).doubleValue();
            double lon = ((Number)a.getProperties().get("longitude", Number.class).get()).doubleValue();
            if (GeoUtils.isValidLatitude((double)lat) && GeoUtils.isValidLongitude((double)lon)) {
                HashMap<String, Object> geojson = new HashMap<String, Object>();
                geojson.put(TYPE, "Point");
                geojson.put("coordinates", List.of(Double.valueOf(lon), Double.valueOf(lat)));
                ma.put(GEO, geojson);
            }
        }
        if (a.getBounds() instanceof SpanBounds) {
            SpanBounds sb = (SpanBounds)a.getBounds();
            ma.put(BEGIN, sb.getBegin());
            ma.put(END, sb.getEnd());
            if (ElasticsearchUtils.shouldPersistData(c.getDataClass())) {
                sb.getData(c).ifPresent(value -> ma.put(VALUE, value));
            }
        }
        return ma;
    }

    public static Map<String, Object> annotationMapping() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(ID, ElasticsearchUtils.mappingType("keyword"));
        m.put(TYPE, ElasticsearchUtils.mappingType("keyword"));
        m.put(BOUNDS_TYPE, ElasticsearchUtils.mappingType("keyword"));
        m.put(GEO, ElasticsearchUtils.mappingType("geo_shape"));
        m.put(BEGIN, ElasticsearchUtils.mappingType("integer"));
        m.put(END, ElasticsearchUtils.mappingType("integer"));
        return m;
    }

    public static Map<String, Object> contentToMap(Content<?> c, boolean forceString) {
        Map<String, Object> contentProps;
        HashMap<String, Object> mc = new HashMap<String, Object>();
        mc.put(ID, c.getId());
        mc.put(CONTENT_TYPE, c.getDataClass().getName());
        if (!c.getDescription().isBlank()) {
            mc.put(DESCRIPTION, c.getDescription());
        }
        if (ElasticsearchUtils.shouldPersistData(c.getDataClass())) {
            mc.put(CONTENT, c.getData());
        }
        if (!(contentProps = c.getProperties().getAll()).isEmpty()) {
            mc.put(PROPERTIES, forceString ? ElasticsearchUtils.toStringMap(contentProps) : contentProps);
        }
        return mc;
    }

    public static Map<String, Object> contentMapping() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(ID, ElasticsearchUtils.mappingType("keyword"));
        m.put(CONTENT_TYPE, ElasticsearchUtils.mappingType("keyword"));
        m.put(DESCRIPTION, ElasticsearchUtils.mappingType("text"));
        return m;
    }

    public static Map<String, Object> groupToMap(Group g, boolean forceString) {
        HashMap<String, Object> mg = new HashMap<String, Object>();
        mg.put(ID, g.getId());
        mg.put(TYPE, g.getType());
        Map<String, Object> groupProps = g.getProperties().getAll();
        if (!groupProps.isEmpty()) {
            mg.put(PROPERTIES, forceString ? ElasticsearchUtils.toStringMap(groupProps) : groupProps);
        }
        HashMap roles = new HashMap();
        Map mar = g.getReferences();
        for (String role : mar.keySet()) {
            List lr = ((Stream)mar.get(role)).map(r -> {
                HashMap<String, String> mr = new HashMap<String, String>();
                mr.put(CONTENT_ID, r.getContentId());
                mr.put(ANNOTATION_ID, r.getAnnotationId());
                return mr;
            }).collect(Collectors.toList());
            roles.put(role, lr);
        }
        mg.put(ROLES, roles);
        return mg;
    }

    public static Map<String, Object> groupMapping() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(ID, ElasticsearchUtils.mappingType("keyword"));
        m.put(TYPE, ElasticsearchUtils.mappingType("keyword"));
        return m;
    }

    public static Map<String, Object> itemToMap(Item i, boolean forceString) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(ID, i.getId());
        i.getParent().ifPresent(parent -> m.put(PARENT, parent));
        Map<String, Object> itemProps = i.getProperties().getAll();
        if (!itemProps.isEmpty()) {
            m.put(PROPERTIES, forceString ? ElasticsearchUtils.toStringMap(itemProps) : itemProps);
        }
        return m;
    }

    public static Map<String, Object> itemMapping() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(ID, ElasticsearchUtils.mappingType("keyword"));
        m.put(PARENT, ElasticsearchUtils.mappingType("keyword"));
        return m;
    }

    public static boolean shouldPersistData(Class<?> dataClass) {
        return String.class.isAssignableFrom(dataClass) || Number.class.isAssignableFrom(dataClass) || Boolean.class.isAssignableFrom(dataClass);
    }

    public static Map<String, Object> wrapWithProperties(Map<String, Object> m) {
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        wrapper.put(PROPERTIES, m);
        return wrapper;
    }

    public static Map<String, Object> mappingType(String type) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put(TYPE, type);
        return m;
    }

    public static Map<String, Object> toStringMap(Map<String, Object> map) {
        HashMap<String, Object> m = new HashMap<String, Object>();
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                try {
                    Map me = (Map)value;
                    m.put((String)key, ElasticsearchUtils.toStringMap(me));
                }
                catch (ClassCastException classCastException) {}
            } else {
                m.put((String)key, value.toString());
            }
        });
        return m;
    }
}

