/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.db.processors;

import io.annot8.api.settings.Description;
import io.annot8.api.settings.Settings;
import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;

public class JdbcSettings
implements Settings {
    public static final int TIMEOUT = 1000;
    private final String jdbcUrl;
    private final String user;
    private final String password;

    public JdbcSettings(String jdbcUrl) {
        this(jdbcUrl, null, null);
    }

    @JsonbCreator
    public JdbcSettings(@JsonbProperty(value="jdbcUrl") String jdbcUrl, @JsonbProperty(value="user") String user, @JsonbProperty(value="password") String password) {
        this.jdbcUrl = jdbcUrl;
        this.user = user;
        this.password = password;
    }

    public boolean validate() {
        return this.jdbcUrl != null && !this.jdbcUrl.isEmpty();
    }

    @Description(value="Valid JDBC URL")
    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Description(value="Username, or null if no password")
    public String getUser() {
        return this.user;
    }

    @Description(value="Password, or null if no password")
    public String getPassword() {
        return this.password;
    }
}

