/*
 * Decompiled with CFR 0.152.
 */
package io.annot8.components.db.processors;

import io.annot8.common.data.content.ColumnMetadata;
import io.annot8.common.data.content.FileContent;
import io.annot8.common.data.content.TableContent;
import io.annot8.common.data.content.TableMetadata;
import io.annot8.components.base.components.AbstractComponent;
import io.annot8.components.db.content.DatabaseTable;
import io.annot8.components.db.processors.JDBCSettings;
import io.annot8.core.capabilities.CreatesContent;
import io.annot8.core.capabilities.ProcessesContent;
import io.annot8.core.components.Processor;
import io.annot8.core.components.responses.ProcessorResponse;
import io.annot8.core.data.Content;
import io.annot8.core.data.Item;
import io.annot8.core.exceptions.Annot8Exception;
import io.annot8.core.exceptions.IncompleteException;
import io.annot8.core.exceptions.UnsupportedContentException;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@ProcessesContent(value=FileContent.class)
@CreatesContent(value=TableContent.class)
public class SQLiteDatabaseTableExtractor
extends AbstractComponent
implements Processor {
    public static final String PROPERTY_TYPE = "TABLE_METADATA";
    private static final String SCHEMA_QUERY = "pragma schema_version";
    private static final String TABLE_SIZE_PREFIX = "SELECT count(*) FROM ";

    public ProcessorResponse process(Item item) throws Annot8Exception {
        boolean withoutError = item.getContents(FileContent.class).filter(this::isSQLite).map(c -> this.createTables(item, (FileContent)c)).reduce(true, (a, b) -> a != false && b != false);
        return withoutError ? ProcessorResponse.ok() : ProcessorResponse.itemError();
    }

    private boolean createTables(Item item, FileContent sqliteFile) {
        JDBCSettings settings = this.getConnectionSettings(sqliteFile);
        List<TableMetadata> tables = this.getTables(settings);
        return tables.stream().map(t -> this.createDatabaseTable(item, (TableMetadata)t, settings)).reduce(true, (a, b) -> a != false && b != false);
    }

    private boolean createDatabaseTable(Item item, TableMetadata tableMetadata, JDBCSettings settings) {
        try {
            ((Content.Builder)item.create(TableContent.class).withName(tableMetadata.getName()).withData((Object)new DatabaseTable(tableMetadata, settings)).withProperty(PROPERTY_TYPE, (Object)tableMetadata)).save();
            return true;
        }
        catch (UnsupportedContentException e) {
            this.log().error("Failed to produce content of the given type ", (Throwable)e);
            return false;
        }
        catch (IncompleteException e) {
            this.log().error("Failed to save content", (Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSQLite(FileContent content) {
        if (!((File)content.getData()).exists()) {
            return false;
        }
        JDBCSettings settings = this.getConnectionSettings(content);
        try (Connection connection = DriverManager.getConnection(settings.getJdbcUrl());){
            ResultSet set = connection.createStatement().executeQuery(SCHEMA_QUERY);
            int schemaVersion = 0;
            if (set.next()) {
                schemaVersion = set.getInt("schema_version");
            }
            if (schemaVersion <= 0) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private JDBCSettings getConnectionSettings(FileContent content) {
        String jdbcUrl = "jdbc:sqlite:/" + ((File)content.getData()).getAbsolutePath();
        return new JDBCSettings(jdbcUrl);
    }

    private List<TableMetadata> getTables(JDBCSettings settings) {
        ArrayList<TableMetadata> tables = new ArrayList<TableMetadata>();
        try (Connection connection = DriverManager.getConnection(settings.getJdbcUrl());){
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet set = metaData.getTables(null, null, null, null);
            while (set.next()) {
                String tableName = set.getString("TABLE_NAME");
                String tableType = set.getString("TABLE_TYPE");
                List<ColumnMetadata> columns = this.getColumnMetadata(metaData, tableName);
                int rowSize = this.getRowCount(connection, tableName);
                tables.add(new TableMetadata(tableName, tableType, columns, rowSize));
            }
        }
        catch (SQLException e) {
            this.log().error("Failed to extract table names", (Throwable)e);
            return Collections.emptyList();
        }
        return tables;
    }

    private List<ColumnMetadata> getColumnMetadata(DatabaseMetaData metadata, String tableName) throws SQLException {
        ArrayList<ColumnMetadata> columnMetadata = new ArrayList<ColumnMetadata>();
        ResultSet set = metadata.getColumns(null, null, tableName, null);
        while (set.next()) {
            String columnName = set.getString("COLUMN_NAME");
            String type = set.getString("TYPE_NAME");
            long size = set.getLong("COLUMN_SIZE");
            columnMetadata.add(new ColumnMetadata(columnName, size));
        }
        return columnMetadata;
    }

    private int getRowCount(Connection connection, String tableName) {
        int n;
        block8: {
            Statement statement = connection.createStatement();
            Throwable throwable = null;
            try {
                ResultSet resultSet = statement.executeQuery(TABLE_SIZE_PREFIX + tableName);
                n = resultSet.getInt(1);
                if (statement == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (statement != null) {
                            SQLiteDatabaseTableExtractor.$closeResource(throwable, statement);
                        }
                        throw throwable3;
                    }
                }
                catch (SQLException e) {
                    this.log().error("Failed to fetch table size for " + tableName, (Throwable)e);
                    return -1;
                }
            }
            SQLiteDatabaseTableExtractor.$closeResource(throwable, statement);
        }
        return n;
    }
}

