/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.application;

import io.allune.quickfixj.spring.boot.starter.model.Create;
import io.allune.quickfixj.spring.boot.starter.model.FromAdmin;
import io.allune.quickfixj.spring.boot.starter.model.FromApp;
import io.allune.quickfixj.spring.boot.starter.model.Logon;
import io.allune.quickfixj.spring.boot.starter.model.Logout;
import io.allune.quickfixj.spring.boot.starter.model.ToAdmin;
import io.allune.quickfixj.spring.boot.starter.model.ToApp;
import java.util.function.Consumer;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import quickfix.Application;
import quickfix.Message;
import quickfix.SessionID;

public class EventPublisherApplicationAdapter
implements Application {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventPublisherApplicationAdapter.class);
    private Consumer<Object> publishEventConsumer = arg_0 -> ((ApplicationEventPublisher)applicationEventPublisher).publishEvent(arg_0);

    public EventPublisherApplicationAdapter(ApplicationEventPublisher applicationEventPublisher) {
    }

    public void fromAdmin(Message message, SessionID sessionId) {
        this.publishEvent(FromAdmin.of(message, sessionId));
    }

    public void fromApp(Message message, SessionID sessionId) {
        this.publishEvent(FromApp.of(message, sessionId));
    }

    public void onCreate(SessionID sessionId) {
        this.publishEvent(Create.of(sessionId));
    }

    public void onLogon(SessionID sessionId) {
        this.publishEvent(Logon.of(sessionId));
    }

    public void onLogout(SessionID sessionId) {
        this.publishEvent(Logout.of(sessionId));
    }

    public void toAdmin(Message message, SessionID sessionId) {
        this.publishEvent(ToAdmin.of(message, sessionId));
    }

    public void toApp(Message message, SessionID sessionId) {
        this.publishEvent(ToApp.of(message, sessionId));
    }

    private <T> void publishEvent(T event) {
        try {
            this.publishEventConsumer.accept(event);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

