/*
 * Decompiled with CFR 0.152.
 */
package io.allune.quickfixj.spring.boot.starter.connection;

import io.allune.quickfixj.spring.boot.starter.exception.SettingsNotFoundException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import quickfix.ConfigError;
import quickfix.SessionSettings;

public class SessionSettingsLocator {
    private static final Logger log = LoggerFactory.getLogger(SessionSettingsLocator.class);
    private final ResourceLoader resourceLoader;

    public SessionSettingsLocator(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public SessionSettings loadSettings(String ... locations) {
        try {
            for (String location : locations) {
                Optional<Resource> resource = this.load(location);
                if (!resource.isPresent()) continue;
                log.info("Loading settings from '{}'", (Object)location);
                return new SessionSettings(resource.get().getInputStream());
            }
            throw new SettingsNotFoundException("Settings file not found");
        }
        catch (IOException | RuntimeException | ConfigError e) {
            throw new SettingsNotFoundException(e.getMessage(), e);
        }
    }

    public SessionSettings loadSettingsFromString(String configString) {
        try {
            return new SessionSettings((InputStream)new ByteArrayInputStream(configString.getBytes()));
        }
        catch (RuntimeException | ConfigError e) {
            throw new SettingsNotFoundException(e.getMessage(), e);
        }
    }

    private Optional<Resource> load(String location) {
        if (location == null) {
            return Optional.empty();
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(this.resourceLoader);
        Resource resource = resolver.getResource(location);
        return resource.exists() ? Optional.of(resource) : Optional.empty();
    }
}

