/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.worker;

import io.aleph0.yap.core.ProcessorWorker;
import io.aleph0.yap.core.Sink;
import io.aleph0.yap.core.Source;
import java.util.Objects;
import java.util.function.Function;

public class MapProcessorWorker<X, Y>
implements ProcessorWorker<X, Y> {
    private final Function<X, Y> function;

    public MapProcessorWorker(Function<X, Y> function) {
        this.function = Objects.requireNonNull(function, "function");
    }

    @Override
    public void process(Source<X> source, Sink<Y> sink) throws InterruptedException {
        X originalItem = source.take();
        while (originalItem != null) {
            Y mappedItem = this.function.apply(originalItem);
            sink.put(mappedItem);
            originalItem = source.take();
        }
    }
}

