/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.worker;

import io.aleph0.yap.core.ProcessorWorker;
import io.aleph0.yap.core.Sink;
import io.aleph0.yap.core.Source;
import java.util.Objects;
import java.util.function.Predicate;

public class FilterProcessorWorker<T>
implements ProcessorWorker<T, T> {
    private final Predicate<T> predicate;

    public FilterProcessorWorker(Predicate<T> predicate) {
        this.predicate = Objects.requireNonNull(predicate, "predicate");
    }

    @Override
    public void process(Source<T> source, Sink<T> sink) throws InterruptedException {
        T item = source.take();
        while (item != null) {
            if (this.predicate.test(item)) {
                sink.put(item);
            }
            item = source.take();
        }
    }
}

