/*
 * Decompiled with CFR 0.152.
 */
package io.aleph0.yap.core.task;

import io.aleph0.yap.core.task.TaskController;
import io.aleph0.yap.core.task.action.TaskAction;
import io.aleph0.yap.core.transport.Queue;
import io.aleph0.yap.core.transport.Topic;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTaskController<InputT, OutputT>
implements TaskController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultTaskController.class);
    private final int desiredConcurrency;
    private final Duration heartbeatInterval;
    private final Queue<InputT> queue;
    private final Topic<OutputT> topic;
    ExecutionException failureCause;
    TaskState state = TaskState.READY;
    int workers = 0;
    int starting = 0;

    public DefaultTaskController(int desiredConcurrency, Duration heartbeatInterval, Queue<InputT> queue, Topic<OutputT> topic) {
        if (desiredConcurrency < 1) {
            throw new IllegalArgumentException("parallelism must be at least 1");
        }
        if (heartbeatInterval == null) {
            throw new NullPointerException();
        }
        if (!heartbeatInterval.isPositive()) {
            throw new IllegalArgumentException("heartbeatInterval must be positive");
        }
        this.desiredConcurrency = desiredConcurrency;
        this.heartbeatInterval = heartbeatInterval;
        this.queue = queue;
        this.topic = topic;
    }

    @Override
    public List<TaskAction> onTaskStart() {
        ArrayList<TaskAction> actions = new ArrayList<TaskAction>();
        switch (this.state.ordinal()) {
            case 0: {
                this.state = this.state.to(TaskState.RUNNING);
                for (int i = 1; i <= this.desiredConcurrency; ++i) {
                    actions.add(TaskAction.newStartWorkerTaskAction());
                    ++this.starting;
                }
                break;
            }
            default: {
                throw new IllegalStateException("task in state " + String.valueOf((Object)this.state));
            }
        }
        return actions;
    }

    @Override
    public List<TaskAction> onWorkerStarted(int id) {
        --this.starting;
        ++this.workers;
        ArrayList<TaskAction> actions = new ArrayList<TaskAction>();
        switch (this.state.ordinal()) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                actions.add(TaskAction.newStopWorkerTaskAction());
                break;
            }
            default: {
                throw new IllegalStateException("task in state " + String.valueOf((Object)this.state));
            }
        }
        return actions;
    }

    @Override
    public List<TaskAction> onWorkerCompletedNormally(int id) {
        --this.workers;
        ArrayList<TaskAction> actions = new ArrayList<TaskAction>();
        switch (this.state.ordinal()) {
            case 1: {
                if (this.workers == 0) {
                    this.state = this.state.to(TaskState.COMPLETED);
                    actions.add(TaskAction.newSucceedTask());
                    break;
                }
                this.state = this.state.to(TaskState.COMPLETING);
                break;
            }
            case 2: {
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.COMPLETED);
                actions.add(TaskAction.newSucceedTask());
                break;
            }
            case 3: {
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.CANCELED);
                actions.add(TaskAction.newCancelTask());
                break;
            }
            case 4: {
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.FAILED);
                actions.add(TaskAction.newFailTask(this.failureCause));
                break;
            }
            default: {
                throw new IllegalStateException("task in state " + String.valueOf((Object)this.state));
            }
        }
        return actions;
    }

    @Override
    public List<TaskAction> onWorkerStopped(int id) {
        --this.workers;
        ArrayList<TaskAction> actions = new ArrayList<TaskAction>();
        switch (this.state.ordinal()) {
            case 1: {
                LOGGER.atWarn().addKeyValue("id", (Object)id).addKeyValue("state", (Object)this.state).log("Worker stopped unexpectedly in RUNNING state.");
                ++this.starting;
                actions.add(TaskAction.newStartWorkerTaskAction());
                break;
            }
            case 2: {
                LOGGER.atWarn().addKeyValue("id", (Object)id).addKeyValue("state", (Object)this.state).log("Worker stopped unexpectedly in COMPLETING state.");
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.COMPLETED);
                actions.add(TaskAction.newSucceedTask());
                break;
            }
            case 3: {
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.CANCELED);
                actions.add(TaskAction.newCancelTask());
                break;
            }
            case 4: {
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.FAILED);
                actions.add(TaskAction.newFailTask(this.failureCause));
                break;
            }
            default: {
                throw new IllegalStateException("task in state " + String.valueOf((Object)this.state));
            }
        }
        return actions;
    }

    @Override
    public List<TaskAction> onWorkerCompletedExceptionally(int id, Throwable error) {
        --this.workers;
        while (error instanceof ExecutionException) {
            error = error.getCause();
        }
        if (this.failureCause == null) {
            this.failureCause = new ExecutionException("Error in task " + id, error);
        } else {
            this.failureCause.addSuppressed(error);
        }
        ArrayList<TaskAction> actions = new ArrayList<TaskAction>();
        switch (this.state.ordinal()) {
            case 1: 
            case 2: 
            case 3: {
                this.state = this.state.to(TaskState.FAILING);
                if (this.topic != null) {
                    this.topic.close();
                }
                if (this.workers != 0) {
                    for (int i = 1; i <= this.workers; ++i) {
                        actions.add(TaskAction.newStopWorkerTaskAction());
                    }
                }
            }
            case 4: {
                if (this.workers != 0) break;
                this.state = this.state.to(TaskState.FAILED);
                actions.add(TaskAction.newFailTask(this.failureCause));
                break;
            }
            default: {
                throw new IllegalStateException("task in state " + String.valueOf((Object)this.state));
            }
        }
        return actions;
    }

    @Override
    public List<TaskAction> onCancelRequested() {
        ArrayList<TaskAction> actions = new ArrayList<TaskAction>();
        switch (this.state.ordinal()) {
            case 1: 
            case 2: {
                this.state = this.state.to(TaskState.CANCELING);
                if (this.topic != null) {
                    this.topic.close();
                }
                if (this.workers == 0 && this.starting == 0) {
                    this.state = this.state.to(TaskState.CANCELED);
                    actions.add(TaskAction.newCancelTask());
                    break;
                }
                for (int i = 0; i < this.workers; ++i) {
                    actions.add(TaskAction.newStopWorkerTaskAction());
                }
                break;
            }
            case 4: {
                LOGGER.atWarn().addKeyValue("state", (Object)this.state).log("Cancel requested in FAILING state. Ignoring.");
                break;
            }
            case 3: {
                LOGGER.atWarn().addKeyValue("state", (Object)this.state).log("Cancel requested in CANCELING state. Ignoring.");
                break;
            }
            default: {
                throw new IllegalStateException("task in state " + String.valueOf((Object)this.state));
            }
        }
        return actions;
    }

    @Override
    public List<TaskAction> onHeartbeat() {
        if (this.state != TaskState.RUNNING) {
            LOGGER.atWarn().addKeyValue("state", (Object)this.state).log("Heartbeat received in non-running state");
        }
        return List.of();
    }

    @Override
    public void onTaskSucceeded() {
    }

    @Override
    public void onTaskCancelled() {
    }

    @Override
    public void onTaskFailed(ExecutionException e) {
    }

    @Override
    public Duration getHeartbeatInterval() {
        return this.heartbeatInterval;
    }

    public static enum TaskState {
        READY(TaskPhase.STARTING){

            @Override
            public TaskState to(TaskState target) {
                if (target == RUNNING) {
                    return RUNNING;
                }
                throw new IllegalStateException("cannot transition from READY to " + String.valueOf((Object)target));
            }
        }
        ,
        RUNNING(TaskPhase.RUNNING){

            @Override
            public TaskState to(TaskState target) {
                if (target == COMPLETING || target == COMPLETED || target == CANCELING || target == FAILING || target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from RUNNING to " + String.valueOf((Object)target));
            }
        }
        ,
        COMPLETING(TaskPhase.FINISHING){

            @Override
            public TaskState to(TaskState target) {
                if (target == COMPLETED || target == CANCELING || target == FAILING || target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from COMPLETING to " + String.valueOf((Object)target));
            }
        }
        ,
        CANCELING(TaskPhase.FINISHING){

            @Override
            public TaskState to(TaskState target) {
                if (target == CANCELED || target == FAILING || target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from CANCELING to " + String.valueOf((Object)target));
            }
        }
        ,
        FAILING(TaskPhase.FINISHING){

            @Override
            public TaskState to(TaskState target) {
                if (target == FAILED) {
                    return target;
                }
                throw new IllegalStateException("cannot transition from FAILING to " + String.valueOf((Object)target));
            }
        }
        ,
        COMPLETED(TaskPhase.FINISHED){

            @Override
            public TaskState to(TaskState target) {
                throw new IllegalStateException("cannot transition from COMPLETED to " + String.valueOf((Object)target));
            }
        }
        ,
        CANCELED(TaskPhase.FINISHED){

            @Override
            public TaskState to(TaskState target) {
                throw new IllegalStateException("cannot transition from CANCELED to " + String.valueOf((Object)target));
            }
        }
        ,
        FAILED(TaskPhase.FINISHED){

            @Override
            public TaskState to(TaskState target) {
                throw new IllegalStateException("cannot transition from FAILED to " + String.valueOf((Object)target));
            }
        };

        private final TaskPhase phase;

        private TaskState(TaskPhase phase) {
            this.phase = Objects.requireNonNull(phase);
        }

        public TaskPhase getPhase() {
            return this.phase;
        }

        public abstract TaskState to(TaskState var1);
    }

    public static enum TaskPhase {
        STARTING,
        RUNNING,
        FINISHING,
        FINISHED;

    }
}

